/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.ansible.vault;

import java.beans.ConstructorProperties;
import java.nio.file.Paths;
import java.util.List;
import lombok.Generated;
import org.kiwiproject.ansible.vault.OsCommand;
import org.kiwiproject.ansible.vault.VaultConfiguration;
import org.kiwiproject.base.KiwiPreconditions;

public class VaultRekeyCommand
implements OsCommand {
    private final String ansibleVaultPath;
    private final String vaultPasswordFilePath;
    private final String encryptedFilePath;
    private final String newVaultPasswordFilePath;

    public static VaultRekeyCommand from(VaultConfiguration configuration, String encryptedFilePath, String newVaultPasswordFilePath) {
        KiwiPreconditions.checkArgumentNotNull(configuration, "configuration cannot be null");
        KiwiPreconditions.checkArgumentNotBlank(encryptedFilePath, "encryptedFilePath cannot be blank");
        KiwiPreconditions.checkArgumentNotBlank(newVaultPasswordFilePath, "newVaultPasswordFilePath cannot be blank");
        return VaultRekeyCommand.builder().ansibleVaultPath(configuration.getAnsibleVaultPath()).vaultPasswordFilePath(configuration.getVaultPasswordFilePath()).encryptedFilePath(encryptedFilePath).newVaultPasswordFilePath(newVaultPasswordFilePath).build();
    }

    @Override
    public List<String> getCommandParts() {
        return List.of(this.ansibleVaultPath, "rekey", "--vault-password-file", this.vaultPasswordFilePath, "--new-vault-password-file", this.newVaultPasswordFilePath, Paths.get(this.encryptedFilePath, new String[0]).toString());
    }

    @ConstructorProperties(value={"ansibleVaultPath", "vaultPasswordFilePath", "encryptedFilePath", "newVaultPasswordFilePath"})
    @Generated
    VaultRekeyCommand(String ansibleVaultPath, String vaultPasswordFilePath, String encryptedFilePath, String newVaultPasswordFilePath) {
        this.ansibleVaultPath = ansibleVaultPath;
        this.vaultPasswordFilePath = vaultPasswordFilePath;
        this.encryptedFilePath = encryptedFilePath;
        this.newVaultPasswordFilePath = newVaultPasswordFilePath;
    }

    @Generated
    public static VaultRekeyCommandBuilder builder() {
        return new VaultRekeyCommandBuilder();
    }

    @Generated
    public static class VaultRekeyCommandBuilder {
        @Generated
        private String ansibleVaultPath;
        @Generated
        private String vaultPasswordFilePath;
        @Generated
        private String encryptedFilePath;
        @Generated
        private String newVaultPasswordFilePath;

        @Generated
        VaultRekeyCommandBuilder() {
        }

        @Generated
        public VaultRekeyCommandBuilder ansibleVaultPath(String ansibleVaultPath) {
            this.ansibleVaultPath = ansibleVaultPath;
            return this;
        }

        @Generated
        public VaultRekeyCommandBuilder vaultPasswordFilePath(String vaultPasswordFilePath) {
            this.vaultPasswordFilePath = vaultPasswordFilePath;
            return this;
        }

        @Generated
        public VaultRekeyCommandBuilder encryptedFilePath(String encryptedFilePath) {
            this.encryptedFilePath = encryptedFilePath;
            return this;
        }

        @Generated
        public VaultRekeyCommandBuilder newVaultPasswordFilePath(String newVaultPasswordFilePath) {
            this.newVaultPasswordFilePath = newVaultPasswordFilePath;
            return this;
        }

        @Generated
        public VaultRekeyCommand build() {
            return new VaultRekeyCommand(this.ansibleVaultPath, this.vaultPasswordFilePath, this.encryptedFilePath, this.newVaultPasswordFilePath);
        }

        @Generated
        public String toString() {
            return "VaultRekeyCommand.VaultRekeyCommandBuilder(ansibleVaultPath=" + this.ansibleVaultPath + ", vaultPasswordFilePath=" + this.vaultPasswordFilePath + ", encryptedFilePath=" + this.encryptedFilePath + ", newVaultPasswordFilePath=" + this.newVaultPasswordFilePath + ")";
        }
    }
}

