/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiStrings;

public final class KiwiPreconditions {
    @VisibleForTesting
    static final int MAX_PORT_NUMBER = 65535;

    public static <T extends Throwable> void checkArgument(boolean expression, Class<T> exceptionType) {
        if (!expression) {
            throw (Throwable)exceptionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    public static <T extends Throwable> void checkArgument(boolean expression, Class<T> exceptionType, String errorMessage) {
        if (!expression) {
            Constructor<T> constructor = exceptionType.getConstructor(String.class);
            throw (Throwable)constructor.newInstance(errorMessage);
        }
    }

    public static <T extends Throwable> void checkArgument(boolean expression, Class<T> exceptionType, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            Constructor<T> constructor = exceptionType.getConstructor(String.class);
            throw (Throwable)constructor.newInstance(KiwiStrings.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static String requireNotBlank(String value) {
        KiwiPreconditions.checkArgumentNotBlank(value);
        return value;
    }

    public static String requireNotBlank(String value, String errorMessage) {
        KiwiPreconditions.checkArgumentNotBlank(value, errorMessage);
        return value;
    }

    public static String requireNotBlank(String value, String errorMessageTemplate, Object ... errorMessageArgs) {
        KiwiPreconditions.checkArgumentNotBlank(value, errorMessageTemplate, errorMessageArgs);
        return value;
    }

    public static <T> T requireNotNull(T reference) {
        KiwiPreconditions.checkArgumentNotNull(reference);
        return reference;
    }

    public static <T> T requireNotNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        KiwiPreconditions.checkArgumentNotNull(reference, errorMessageTemplate, errorMessageArgs);
        return reference;
    }

    public static <T> void checkArgumentNotNull(T reference) {
        Preconditions.checkArgument((boolean)Objects.nonNull(reference));
    }

    public static <T> void checkArgumentNotNull(T reference, String errorMessage) {
        Preconditions.checkArgument((boolean)Objects.nonNull(reference), (Object)errorMessage);
    }

    public static <T> void checkArgumentNotNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (Objects.isNull(reference)) {
            throw KiwiPreconditions.newIllegalArgumentException(errorMessageTemplate, errorMessageArgs);
        }
    }

    private static IllegalArgumentException newIllegalArgumentException(String errorMessageTemplate, Object ... errorMessageArgs) {
        String errorMessage = KiwiStrings.format(errorMessageTemplate, errorMessageArgs);
        return new IllegalArgumentException(errorMessage);
    }

    public static void checkArgumentNotBlank(String string) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)string));
    }

    public static void checkArgumentNotBlank(String string, String errorMessage) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)string), (Object)errorMessage);
    }

    public static void checkArgumentNotBlank(String string, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw KiwiPreconditions.newIllegalArgumentException(errorMessageTemplate, errorMessageArgs);
        }
    }

    @SafeVarargs
    public static <T> void checkEvenItemCount(T ... items) {
        KiwiPreconditions.requireNotNull(items);
        KiwiPreconditions.checkEvenItemCount(() -> items.length);
    }

    public static <T> void checkEvenItemCount(Collection<T> items) {
        KiwiPreconditions.requireNotNull(items);
        KiwiPreconditions.checkEvenItemCount(items::size);
    }

    public static void checkEvenItemCount(IntSupplier countSupplier) {
        KiwiPreconditions.requireNotNull(countSupplier);
        int count = countSupplier.getAsInt();
        Preconditions.checkArgument((count % 2 == 0 ? 1 : 0) != 0, (String)"must be an even number of items (received %s)", (int)count);
    }

    public static <T> T requireNotNullElse(T obj, T defaultObj) {
        KiwiPreconditions.checkArgumentNotNull(defaultObj);
        return Objects.isNull(obj) ? defaultObj : obj;
    }

    public static <T> T requireNotNullElseGet(T obj, Supplier<? extends T> supplier) {
        KiwiPreconditions.checkArgumentNotNull(supplier);
        T value = KiwiPreconditions.requireNotNull(supplier.get(), "supplier must return a non-null object", new Object[0]);
        return Objects.isNull(obj) ? value : obj;
    }

    public static void checkPositive(int value) {
        KiwiPreconditions.checkPositive(value, "value must be a positive number");
    }

    public static void checkPositive(int value, String errorMessage) {
        Preconditions.checkState((value > 0 ? 1 : 0) != 0, (Object)errorMessage);
    }

    public static void checkPositive(int value, String errorMessageTemplate, Object ... errorMessageArgs) {
        Preconditions.checkState((value > 0 ? 1 : 0) != 0, (String)errorMessageTemplate, (Object[])errorMessageArgs);
    }

    public static void checkPositive(long value) {
        KiwiPreconditions.checkPositive(value, "value must be a positive number");
    }

    public static void checkPositive(long value, String errorMessage) {
        Preconditions.checkState((value > 0L ? 1 : 0) != 0, (Object)errorMessage);
    }

    public static void checkPositive(long value, String errorMessageTemplate, Object ... errorMessageArgs) {
        Preconditions.checkState((value > 0L ? 1 : 0) != 0, (String)errorMessageTemplate, (Object[])errorMessageArgs);
    }

    public static void checkPositiveOrZero(int value) {
        KiwiPreconditions.checkPositiveOrZero(value, "value must be positive or zero");
    }

    public static void checkPositiveOrZero(int value, String errorMessage) {
        Preconditions.checkState((value >= 0 ? 1 : 0) != 0, (Object)errorMessage);
    }

    public static void checkPositiveOrZero(int value, String errorMessageTemplate, Object ... errorMessageArgs) {
        Preconditions.checkState((value >= 0 ? 1 : 0) != 0, (String)errorMessageTemplate, (Object[])errorMessageArgs);
    }

    public static void checkPositiveOrZero(long value) {
        KiwiPreconditions.checkPositiveOrZero(value, "value must be positive or zero");
    }

    public static void checkPositiveOrZero(long value, String errorMessage) {
        Preconditions.checkState((value >= 0L ? 1 : 0) != 0, (Object)errorMessage);
    }

    public static void checkPositiveOrZero(long value, String errorMessageTemplate, Object ... errorMessageArgs) {
        Preconditions.checkState((value >= 0L ? 1 : 0) != 0, (String)errorMessageTemplate, (Object[])errorMessageArgs);
    }

    public static int requirePositive(int value) {
        KiwiPreconditions.checkPositive(value);
        return value;
    }

    public static int requirePositive(int value, String errorMessage) {
        KiwiPreconditions.checkPositive(value, errorMessage);
        return value;
    }

    public static int requirePositive(int value, String errorMessageTemplate, Object ... errorMessageArgs) {
        KiwiPreconditions.checkPositive(value, errorMessageTemplate, errorMessageArgs);
        return value;
    }

    public static long requirePositive(long value) {
        KiwiPreconditions.checkPositive(value);
        return value;
    }

    public static long requirePositive(long value, String errorMessage) {
        KiwiPreconditions.checkPositive(value, errorMessage);
        return value;
    }

    public static long requirePositive(long value, String errorMessageTemplate, Object ... errorMessageArgs) {
        KiwiPreconditions.checkPositive(value, errorMessageTemplate, errorMessageArgs);
        return value;
    }

    public static int requirePositiveOrZero(int value) {
        KiwiPreconditions.checkPositiveOrZero(value);
        return value;
    }

    public static int requirePositiveOrZero(int value, String errorMessage) {
        KiwiPreconditions.checkPositiveOrZero(value, errorMessage);
        return value;
    }

    public static int requirePositiveOrZero(int value, String errorMessageTemplate, Object ... errorMessageArgs) {
        KiwiPreconditions.checkPositiveOrZero(value, errorMessageTemplate, errorMessageArgs);
        return value;
    }

    public static long requirePositiveOrZero(long value) {
        KiwiPreconditions.checkPositiveOrZero(value);
        return value;
    }

    public static long requirePositiveOrZero(long value, String errorMessage) {
        KiwiPreconditions.checkPositiveOrZero(value, errorMessage);
        return value;
    }

    public static long requirePositiveOrZero(long value, String errorMessageTemplate, Object ... errorMessageArgs) {
        KiwiPreconditions.checkPositiveOrZero(value, errorMessageTemplate, errorMessageArgs);
        return value;
    }

    public static void checkValidPort(int port) {
        KiwiPreconditions.checkValidPort(port, "port must be between 0 and %s", 65535);
    }

    public static void checkValidPort(int port, String errorMessage) {
        Preconditions.checkState((port >= 0 && port <= 65535 ? 1 : 0) != 0, (Object)errorMessage);
    }

    public static void checkValidPort(int port, String errorMessageTemplate, Object ... errorMessageArgs) {
        Preconditions.checkState((port >= 0 && port <= 65535 ? 1 : 0) != 0, (String)errorMessageTemplate, (Object[])errorMessageArgs);
    }

    public static int requireValidPort(int port) {
        KiwiPreconditions.checkValidPort(port);
        return port;
    }

    public static int requireValidPort(int port, String errorMessage) {
        KiwiPreconditions.checkValidPort(port, errorMessage);
        return port;
    }

    public static int requireValidPort(int port, String errorMessageTemplate, Object ... errorMessageArgs) {
        KiwiPreconditions.checkValidPort(port, errorMessageTemplate, errorMessageArgs);
        return port;
    }

    public static void checkValidNonZeroPort(int port) {
        KiwiPreconditions.checkValidNonZeroPort(port, "port must be between 1 and %s", 65535);
    }

    public static void checkValidNonZeroPort(int port, String errorMessage) {
        Preconditions.checkState((port > 0 && port <= 65535 ? 1 : 0) != 0, (Object)errorMessage);
    }

    public static void checkValidNonZeroPort(int port, String errorMessageTemplate, Object ... errorMessageArgs) {
        Preconditions.checkState((port > 0 && port <= 65535 ? 1 : 0) != 0, (String)errorMessageTemplate, (Object[])errorMessageArgs);
    }

    public static int requireValidNonZeroPort(int port) {
        KiwiPreconditions.checkValidNonZeroPort(port);
        return port;
    }

    public static int requireValidNonZeroPort(int port, String errorMessage) {
        KiwiPreconditions.checkValidNonZeroPort(port, errorMessage);
        return port;
    }

    public static int requireValidNonZeroPort(int port, String errorMessageTemplate, Object ... errorMessageArgs) {
        KiwiPreconditions.checkValidNonZeroPort(port, errorMessageTemplate, errorMessageArgs);
        return port;
    }

    @Generated
    private KiwiPreconditions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

