/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base.process;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.base.UncheckedInterruptedException;
import org.kiwiproject.base.process.KillSignal;
import org.kiwiproject.base.process.KillTimeoutAction;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.io.KiwiIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Processes {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(Processes.class);
    public static final int SUCCESS_EXIT_CODE = 0;
    public static final int DEFAULT_KILL_TIMEOUT_SECONDS = 5;
    public static final long DEFAULT_WAIT_FOR_EXIT_TIME_SECONDS = 5L;
    private static final String PGREP_FULL_COMMAND_MATCH_AND_PRINT_FLAGS;
    private static final boolean PGREP_CHECK_SUCCESSFUL;
    private static final String PGREP_COMMAND = "pgrep";

    private static Pair<String, Boolean> choosePgrepFlags() {
        String flagsOrNull = Processes.findPgrepFlags().orElse(null);
        return Processes.choosePgrepFlags(flagsOrNull);
    }

    @VisibleForTesting
    static Pair<String, Boolean> choosePgrepFlags(@Nullable String flagsOrNull) {
        if (Objects.isNull(flagsOrNull)) {
            Processes.logPgrepFlagWarnings();
            return Pair.of((Object)"-fa", (Object)false);
        }
        return Pair.of((Object)flagsOrNull, (Object)true);
    }

    private static Optional<String> findPgrepFlags() {
        return Processes.tryPgrepForSleepCommand("-fa", "123").or(() -> Processes.tryPgrepForSleepCommand("-fl", "124"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<String> tryPgrepForSleepCommand(String flags, String sleepTime) {
        Process sleeperProc = null;
        try {
            sleeperProc = Processes.launch("sleep", sleepTime);
            String pid = String.valueOf(sleeperProc.pid());
            Process pgrepCheckerProc = Processes.launch(PGREP_COMMAND, flags, "sleep");
            List<String> stdOutLines = KiwiIO.readLinesFromInputStreamOf(pgrepCheckerProc);
            List<String> stdErrLines = KiwiIO.readLinesFromErrorStreamOf(pgrepCheckerProc);
            String expectedCommand = "sleep " + sleepTime;
            Processes.logPgrepCheckInfo(flags, pid, stdOutLines, stdErrLines, expectedCommand);
            if (Processes.linesContainPidAndFullCommand(stdOutLines, pid, expectedCommand)) {
                LOG.info("Will use [{}] as flags for pgrep full-command listing", (Object)flags);
                Optional<String> optional = Optional.of(flags);
                return optional;
            }
            LOG.trace("Flags [{}] did not produce pgrep full-command listing", (Object)flags);
            Optional<String> optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            LOG.error("Error checking pgrep flags. pgrep calls may fail in unexpected ways!", (Throwable)e);
            Optional<String> optional = Optional.empty();
            return optional;
        }
        finally {
            if (Objects.nonNull(sleeperProc)) {
                Processes.killSilently(sleeperProc.pid());
            }
        }
    }

    @VisibleForTesting
    static void logPgrepCheckInfo(String flags, String pid, List<String> stdOutLines, List<String> stdErrLines, String expectedCommand) {
        LOG.trace("Checking pgrep flags [{}] for command [{}] with pid {}", new Object[]{flags, expectedCommand, pid});
        LOG.trace("pid {} stdOut: {}", (Object)pid, stdOutLines);
        if (stdErrLines.isEmpty()) {
            LOG.trace("pid {} stdErr: {}", (Object)pid, stdErrLines);
        } else {
            LOG.warn("stdErr checking pgrep flags for pid {} (command: {}): {}", new Object[]{pid, expectedCommand, stdErrLines});
        }
    }

    private static boolean linesContainPidAndFullCommand(List<String> lines, String pid, String expectedCommand) {
        return lines.stream().anyMatch(line -> line.contains(pid) && line.contains(expectedCommand));
    }

    private static void killSilently(long processId) {
        try {
            LOG.trace("Killing sleeper process ({}) used to determine pgrep flags", (Object)processId);
            Processes.kill(processId, KillSignal.SIGTERM, KillTimeoutAction.NO_OP);
        }
        catch (Exception e) {
            LOG.warn("Error killing sleeper process ({}) used to determine pgrep flags", (Object)processId, (Object)e);
        }
    }

    @VisibleForTesting
    static void logPgrepFlagWarnings() {
        LOG.warn("Neither -fa nor -fl flags produced PID and full command line, so pgrep commands will behave (or fail) in unexpected ways!");
        LOG.warn("If you see this warning, DO NOT use any of the pgrep-related methods in Processes or ProcessHelper and submit a bug report.");
        LOG.warn("Turn on TRACE-level logging to see standard output and error for pgrep commands");
        LOG.warn("We will use -fa even though we know this will not work, instead of throwing an exception");
    }

    public static boolean wasPgrepFlagsCheckSuccessful() {
        return PGREP_CHECK_SUCCESSFUL;
    }

    public static String getPgrepFlags() {
        return PGREP_FULL_COMMAND_MATCH_AND_PRINT_FLAGS;
    }

    public static long processId(Process process) {
        KiwiPreconditions.checkArgumentNotNull(process);
        return process.pid();
    }

    public static OptionalLong processIdOrEmpty(Process process) {
        KiwiPreconditions.checkArgumentNotNull(process);
        try {
            return OptionalLong.of(process.pid());
        }
        catch (UnsupportedOperationException e) {
            LOG.warn("The JDK cannot get the PID of the given Process. Check stack trace for a possible reason", (Throwable)e);
            return OptionalLong.empty();
        }
    }

    public static boolean hasSuccessfulExitCode(Process process) {
        return Processes.isSuccessfulExitCode(process.exitValue());
    }

    public static boolean isSuccessfulExitCode(int exitCode) {
        return exitCode == 0;
    }

    public static Optional<Integer> waitForExit(Process process) {
        return Processes.waitForExit(process, 5L, TimeUnit.SECONDS);
    }

    public static Optional<Integer> waitForExit(Process process, long timeout, TimeUnit unit) {
        try {
            boolean exited = process.waitFor(timeout, unit);
            return exited ? Optional.of(process.exitValue()) : Optional.empty();
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted waiting for process to exit", (Throwable)e);
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
    }

    public static Process launch(List<String> command) {
        try {
            return Processes.launchProcessInternal(command);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error launching command: " + command, e);
        }
    }

    public static Process launch(String ... command) {
        return Processes.launch(Lists.newArrayList((Object[])command));
    }

    public static List<Long> pgrep(String commandLine) {
        return Processes.pgrep(null, commandLine);
    }

    public static List<Long> pgrep(String user, String commandLine) {
        try {
            List<String> command = Processes.buildPgrepCommand(user, commandLine);
            Process process = Processes.launchProcessInternal(command);
            return KiwiIO.streamLinesFromInputStreamOf(process).map(Long::valueOf).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(KiwiStrings.format("Error executing pgrep with user [%s] and command [%s]", user, commandLine), e);
        }
    }

    public static Optional<Long> pgrepWithSingleResult(String commandLine) {
        return Processes.pgrepWithSingleResult(null, commandLine);
    }

    public static Optional<Long> pgrepWithSingleResult(String user, String commandLine) {
        List<Long> pids = Processes.pgrep(user, commandLine);
        if (pids.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkState((pids.size() == 1 ? 1 : 0) != 0, (String)"Expecting exactly one result pid for command [%s], but received %s: %s", (Object)commandLine, (Object)pids.size(), pids);
        return Optional.of(KiwiLists.first(pids));
    }

    public static List<String> pgrepList(String commandLine) {
        return Processes.pgrepList(null, commandLine);
    }

    public static List<String> pgrepList(String user, String commandLine) {
        try {
            List<String> command = Processes.buildPgrepListCommand(user, commandLine);
            Process process = Processes.launchProcessInternal(command);
            return KiwiIO.readLinesFromInputStreamOf(process);
        }
        catch (IOException e) {
            throw new UncheckedIOException(KiwiStrings.format("Error executing pgrep with user [%s] and command [%s]", user, commandLine), e);
        }
    }

    public static List<Pair<Long, String>> pgrepParsedList(String commandLine) {
        return Processes.pgrepParsedList(null, commandLine);
    }

    public static List<Pair<Long, String>> pgrepParsedList(String user, String commandLine) {
        List<String> lines = Processes.pgrepList(user, commandLine);
        return lines.stream().map(Processes::pairFromPgrepLine).collect(Collectors.toList());
    }

    private static Pair<Long, String> pairFromPgrepLine(String line) {
        List<String> splat = KiwiStrings.splitToList((CharSequence)line, ' ', 2);
        return Pair.of((Object)Long.valueOf(KiwiLists.first(splat)), (Object)KiwiLists.second(splat));
    }

    private static List<String> buildPgrepCommand(String user, String commandLine) {
        return Processes.buildPgrepCommand(user, commandLine, "-f");
    }

    private static List<String> buildPgrepListCommand(String user, String commandLine) {
        return Processes.buildPgrepCommand(user, commandLine, PGREP_FULL_COMMAND_MATCH_AND_PRINT_FLAGS);
    }

    private static List<String> buildPgrepCommand(String user, String commandLine, String flags) {
        Preconditions.checkArgument((boolean)Processes.doesNotContainWhitespace(flags), (String)"Currently only short flags specified together with no whitespace are supported, e.g. -fl and NOT -f -l. Offending flags: %s", (Object)flags);
        if (StringUtils.isBlank((CharSequence)user)) {
            return Lists.newArrayList((Object[])new String[]{PGREP_COMMAND, flags, commandLine});
        }
        return Lists.newArrayList((Object[])new String[]{PGREP_COMMAND, "-u", user, flags, commandLine});
    }

    private static boolean doesNotContainWhitespace(String string) {
        return !string.contains(" ");
    }

    public static int kill(long processId, KillSignal signal, KillTimeoutAction action) {
        return Processes.kill(processId, signal.number(), action);
    }

    public static int kill(long processId, String signal, KillTimeoutAction action) {
        return Processes.kill(processId, signal, 5L, TimeUnit.SECONDS, action);
    }

    public static int kill(long processId, KillSignal signal, long timeout, TimeUnit unit, KillTimeoutAction action) {
        return Processes.kill(processId, signal.number(), timeout, unit, action);
    }

    public static int kill(long processId, String signal, long timeout, TimeUnit unit, KillTimeoutAction action) {
        try {
            Process killProcess = Processes.launchProcessInternal("kill", KillSignal.withLeadingDash(signal), String.valueOf(processId));
            return Processes.killInternal(processId, killProcess, timeout, unit, action);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Process launchProcessInternal(String ... commandLine) throws IOException {
        return Processes.launchProcessInternal(Lists.newArrayList((Object[])commandLine));
    }

    private static Process launchProcessInternal(List<String> command) throws IOException {
        return new ProcessBuilder(command).start();
    }

    public static boolean killForcibly(Process process, long timeout, TimeUnit unit) throws InterruptedException {
        return process.destroyForcibly().waitFor(timeout, unit);
    }

    @VisibleForTesting
    static int killInternal(long processId, Process killProcess, long timeout, TimeUnit unit, KillTimeoutAction action) {
        try {
            boolean exitedBeforeWaitTimeout = killProcess.waitFor(timeout, unit);
            if (exitedBeforeWaitTimeout) {
                return killProcess.exitValue();
            }
            return Processes.doTimeoutAction(action, killProcess, processId);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedInterruptedException(e);
        }
    }

    private static int doTimeoutAction(KillTimeoutAction action, Process killProcess, long processId) throws InterruptedException {
        switch (action) {
            case FORCE_KILL: {
                boolean killedBeforeWaitTimeout = Processes.killForcibly(killProcess, 1L, TimeUnit.SECONDS);
                Processes.validateKilledBeforeTimeout(processId, killedBeforeWaitTimeout);
                return killProcess.exitValue();
            }
            case THROW_EXCEPTION: {
                throw new IllegalStateException(KiwiStrings.format("Process %s did not end before timeout (and exception was requested)", processId));
            }
            case NO_OP: {
                LOG.warn("Process {} did not end before timeout and no-op action requested, so doing nothing", (Object)processId);
                return -1;
            }
        }
        throw new IllegalStateException("Unaccounted for action: " + action);
    }

    private static void validateKilledBeforeTimeout(long processId, boolean killedBeforeWaitTimeout) {
        if (!killedBeforeWaitTimeout) {
            throw new IllegalStateException(KiwiStrings.format("Process %s was not killed before 1 second timeout expired", processId));
        }
    }

    @Generated
    private Processes() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        Pair<String, Boolean> result = Processes.choosePgrepFlags();
        PGREP_FULL_COMMAND_MATCH_AND_PRINT_FLAGS = (String)result.getLeft();
        PGREP_CHECK_SUCCESSFUL = (Boolean)result.getRight();
    }
}

