/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.beans;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.beans.FeatureDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;

public class BeanConverter<T> {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(BeanConverter.class);
    private final Map<String, Function<T, ?>> mappers = new HashMap();
    private Set<String> exclusions = Sets.newHashSet((Object[])new String[]{"class", "new"});
    private boolean failOnError;

    public T convert(T input) {
        return this.convert(input, input);
    }

    public <R> R convert(T input, R target) {
        if (Objects.isNull(input)) {
            return null;
        }
        BeanWrapperImpl inputWrapper = new BeanWrapperImpl(input);
        BeanWrapperImpl targetWrapper = new BeanWrapperImpl(target);
        Set<String> propertyNames = this.getPropertySet(input, (BeanWrapper)inputWrapper);
        for (String propName : propertyNames) {
            if (this.hasPropertyMapper(propName)) {
                Function<T, R> func = this.getPropertyMapper(propName);
                func.apply(input);
                continue;
            }
            if (input == target) continue;
            Object inputValue = this.readBeanValue(input, (BeanWrapper)inputWrapper, propName);
            this.writeBeanValue(target, (BeanWrapper)targetWrapper, propName, inputValue);
        }
        return target;
    }

    protected Set<String> getPropertySet(T input, BeanWrapper inputWrapper) {
        Set<String> propertyNames = BeanConverter.getPropertyNamesAsSet(input, inputWrapper);
        return propertyNames.stream().filter(Predicate.not(prop -> this.exclusions.contains(prop))).collect(Collectors.toSet());
    }

    private static <T> Set<String> getPropertyNamesAsSet(T input, BeanWrapper inputWrapper) {
        if (input instanceof Map) {
            return ((Map)input).keySet();
        }
        return Stream.of(inputWrapper.getPropertyDescriptors()).map(FeatureDescriptor::getName).collect(Collectors.toSet());
    }

    public boolean hasPropertyMapper(String propertyName) {
        return this.mappers.containsKey(propertyName);
    }

    public <R> Function<T, R> getPropertyMapper(String propertyName) {
        return this.mappers.get(propertyName);
    }

    protected Object readBeanValue(T input, BeanWrapper inputWrapper, String propName) {
        try {
            return inputWrapper.getPropertyValue(propName);
        }
        catch (NotReadablePropertyException e) {
            if (input instanceof Map) {
                return ((Map)input).get(propName);
            }
            this.logOrFail("Exception trying to read value", propName, (RuntimeException)((Object)e));
            return null;
        }
    }

    protected void logOrFail(String msg, String propName, RuntimeException e) {
        if (this.failOnError) {
            throw e;
        }
        LOG.debug("{} - property: {}", (Object)msg, (Object)propName);
        LOG.trace("Exception: ", (Throwable)e);
    }

    protected <R> void writeBeanValue(R target, BeanWrapper targetWrapper, String propName, Object inputValue) {
        try {
            targetWrapper.setPropertyValue(propName, inputValue);
        }
        catch (NotWritablePropertyException e) {
            if (target instanceof Map) {
                ((Map)target).put(propName, inputValue);
            }
            this.logOrFail("Exception trying to write value", propName, (RuntimeException)((Object)e));
        }
    }

    public void addPropertyMapper(String propertyName, Function<T, ?> function) {
        Preconditions.checkState((!this.mappers.containsKey(propertyName) ? 1 : 0) != 0, (String)"Mapper already registered for property: %s", (Object)propertyName);
        this.mappers.put(propertyName, function);
    }

    @Generated
    public Map<String, Function<T, ?>> getMappers() {
        return this.mappers;
    }

    @Generated
    public Set<String> getExclusions() {
        return this.exclusions;
    }

    @Generated
    public void setExclusions(Set<String> exclusions) {
        this.exclusions = exclusions;
    }

    @Generated
    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Generated
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

