/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.collect;

import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.Generated;
import org.kiwiproject.base.KiwiStrings;

public final class KiwiCollectors {
    public static <T> Collector<T, ImmutableList.Builder<T>, ImmutableList.Builder<T>> toImmutableListBuilder() {
        return Collector.of(ImmutableList::builder, ImmutableList.Builder::add, (builder1, builder2) -> {
            ImmutableList listFromBuilder2 = builder2.build();
            return builder1.addAll((Iterable)listFromBuilder2);
        }, new Collector.Characteristics[0]);
    }

    public static <E extends Enum<E>> Collector<E, EnumSet<E>, EnumSet<E>> toEnumSet(Class<E> type) {
        return Collector.of(() -> EnumSet.noneOf(type), Set::add, (enumSet1, enumSet2) -> {
            enumSet1.addAll(enumSet2);
            return enumSet1;
        }, new Collector.Characteristics[0]);
    }

    public static <T, K extends Enum<K>, U> Collector<T, ?, Map<K, U>> toEnumMap(Class<K> enumClass, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (u1, u2) -> {
            throw KiwiCollectors.duplicateKeyException(u1, u2);
        }, () -> new EnumMap(enumClass));
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toLinkedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (u1, u2) -> {
            throw KiwiCollectors.duplicateKeyException(u1, u2);
        }, LinkedHashMap::new);
    }

    private static IllegalStateException duplicateKeyException(Object u1, Object u2) {
        return new IllegalStateException(KiwiStrings.f("Duplicate key. Attempted to merge values {} and {}", u1, u2));
    }

    @Generated
    private KiwiCollectors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

