/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.collect;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;

public final class KiwiMaps {
    public static <K, V> boolean isNullOrEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static <K, V> boolean isNotNullOrEmpty(Map<K, V> map) {
        return !KiwiMaps.isNullOrEmpty(map);
    }

    public static <K, V> Map<K, V> newHashMap(Object ... items) {
        KiwiPreconditions.checkEvenItemCount(items);
        HashMap map = new HashMap(items.length);
        KiwiMaps.populate(map, items);
        return map;
    }

    public static <K, V> Map<K, V> newLinkedHashMap(Object ... items) {
        KiwiPreconditions.checkEvenItemCount(items);
        LinkedHashMap map = new LinkedHashMap(items.length);
        KiwiMaps.populate(map, items);
        return map;
    }

    public static <K extends Comparable<? super K>, V> SortedMap<K, V> newTreeMap(Object ... items) {
        KiwiPreconditions.checkEvenItemCount(items);
        TreeMap map = new TreeMap();
        KiwiMaps.populate(map, items);
        return map;
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(Object ... items) {
        KiwiPreconditions.checkEvenItemCount(items);
        ConcurrentHashMap map = new ConcurrentHashMap(items.length);
        KiwiMaps.populate(map, items);
        return map;
    }

    private static <K, V> void populate(Map<K, V> map, Object ... items) {
        for (int i = 0; i < items.length; i += 2) {
            Object key = items[i];
            Object value = items[i + 1];
            map.put(key, value);
        }
    }

    public static <K, V> boolean keyExistsWithNullValue(Map<K, V> map, K key) {
        return KiwiMaps.isNotNullOrEmpty(map) && map.containsKey(key) && Objects.isNull(map.get(key));
    }

    @Generated
    private KiwiMaps() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

