/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.config;

import java.beans.ConstructorProperties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.config.UrlRewriteConfiguration;

class EndpointUriBuilder {
    private static final String SLASH = "/";
    private final String scheme;
    private final String host;
    private final String port;
    private final String path;
    private final UrlRewriteConfiguration urlRewriteConfig;

    String getURI() {
        String schemeAndHost = EndpointUriBuilder.getSchemeAndHostString(this.scheme, this.host);
        String hostAndPort = EndpointUriBuilder.getHostAndPort(schemeAndHost, this.port);
        return EndpointUriBuilder.buildUri(hostAndPort, EndpointUriBuilder.getPathPrefix(this.urlRewriteConfig), EndpointUriBuilder.stripLeadingAndTrailingSlashes(this.path));
    }

    private static String getSchemeAndHostString(String scheme, String host) {
        KiwiPreconditions.checkArgumentNotBlank(scheme, "scheme cannot be blank");
        KiwiPreconditions.checkArgumentNotBlank(host, "host cannot be blank");
        return KiwiStrings.f("{}://{}", scheme, host);
    }

    private static String getHostAndPort(String schemeAndHost, String port) {
        return StringUtils.isNotBlank((CharSequence)port) ? KiwiStrings.f("{}:{}", schemeAndHost, port) : schemeAndHost;
    }

    static String stripLeadingAndTrailingSlashes(String value) {
        return StringUtils.strip((String)value, (String)SLASH);
    }

    private static String getPathPrefix(UrlRewriteConfiguration config) {
        return config.shouldRewrite() ? EndpointUriBuilder.stripLeadingAndTrailingSlashes(config.getPathPrefix()) : "";
    }

    private static String buildUri(String ... uriParts) {
        return Stream.of(uriParts).filter(StringUtils::isNotBlank).collect(Collectors.joining(SLASH));
    }

    @ConstructorProperties(value={"scheme", "host", "port", "path", "urlRewriteConfig"})
    @Generated
    EndpointUriBuilder(String scheme, String host, String port, String path, UrlRewriteConfiguration urlRewriteConfig) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.urlRewriteConfig = urlRewriteConfig;
    }

    @Generated
    public static EndpointUriBuilderBuilder builder() {
        return new EndpointUriBuilderBuilder();
    }

    @Generated
    public static class EndpointUriBuilderBuilder {
        @Generated
        private String scheme;
        @Generated
        private String host;
        @Generated
        private String port;
        @Generated
        private String path;
        @Generated
        private UrlRewriteConfiguration urlRewriteConfig;

        @Generated
        EndpointUriBuilderBuilder() {
        }

        @Generated
        public EndpointUriBuilderBuilder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        @Generated
        public EndpointUriBuilderBuilder host(String host) {
            this.host = host;
            return this;
        }

        @Generated
        public EndpointUriBuilderBuilder port(String port) {
            this.port = port;
            return this;
        }

        @Generated
        public EndpointUriBuilderBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public EndpointUriBuilderBuilder urlRewriteConfig(UrlRewriteConfiguration urlRewriteConfig) {
            this.urlRewriteConfig = urlRewriteConfig;
            return this;
        }

        @Generated
        public EndpointUriBuilder build() {
            return new EndpointUriBuilder(this.scheme, this.host, this.port, this.path, this.urlRewriteConfig);
        }

        @Generated
        public String toString() {
            return "EndpointUriBuilder.EndpointUriBuilderBuilder(scheme=" + this.scheme + ", host=" + this.host + ", port=" + this.port + ", path=" + this.path + ", urlRewriteConfig=" + this.urlRewriteConfig + ")";
        }
    }
}

