/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.config;

import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.kiwiproject.config.TlsContextConfiguration;
import org.kiwiproject.security.KeyAndTrustStoreConfigProvider;
import org.kiwiproject.security.KeyStoreType;
import org.kiwiproject.security.SimpleSSLContextFactory;

public class SSLContextConfiguration
implements KeyAndTrustStoreConfigProvider {
    private String keyStorePath;
    private String keyStorePassword;
    private String trustStorePath;
    private String trustStorePassword;
    private String protocol;
    private String keyStoreType;
    private boolean verifyHostname;

    public SSLContextConfiguration() {
        this.keyStoreType = KeyStoreType.JKS.value;
        this.verifyHostname = true;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getTrustStoreType() {
        return this.keyStoreType;
    }

    @Override
    public SSLContext toSSLContext() {
        return this.toSimpleSSLContextFactory().getSslContext();
    }

    public SimpleSSLContextFactory toSimpleSSLContextFactory() {
        return new SimpleSSLContextFactory(this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword, this.protocol, this.verifyHostname);
    }

    public TlsContextConfiguration toTlsContextConfiguration() {
        return this.toTlsContextConfiguration(this.keyStoreType);
    }

    public TlsContextConfiguration toTlsContextConfiguration(String trustStoreType) {
        return TlsContextConfiguration.builder().keyStorePath(this.keyStorePath).keyStorePassword(this.keyStorePassword).keyStoreType(this.keyStoreType).trustStorePath(this.trustStorePath).trustStorePassword(this.trustStorePassword).trustStoreType(trustStoreType).protocol(this.protocol).verifyHostname(this.verifyHostname).build();
    }

    @Override
    @Generated
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Override
    @Generated
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Override
    @Generated
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Override
    @Generated
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Override
    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    @Generated
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Override
    @Generated
    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    @Generated
    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    @Generated
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @Generated
    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    @Generated
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    @Generated
    public void setVerifyHostname(boolean verifyHostname) {
        this.verifyHostname = verifyHostname;
    }

    public static class Builder {
        private final SSLContextConfiguration configuration = new SSLContextConfiguration();

        public Builder keyStorePath(String keyStorePath) {
            return this.setKeyStorePath(keyStorePath);
        }

        public Builder setKeyStorePath(String keyStorePath) {
            this.configuration.setKeyStorePath(keyStorePath);
            return this;
        }

        public Builder keyStorePassword(String keyStorePassword) {
            return this.setKeyStorePassword(keyStorePassword);
        }

        public Builder setKeyStorePassword(String keyStorePassword) {
            this.configuration.setKeyStorePassword(keyStorePassword);
            return this;
        }

        public Builder trustStorePath(String trustStorePath) {
            return this.setTrustStorePath(trustStorePath);
        }

        public Builder setTrustStorePath(String trustStorePath) {
            this.configuration.setTrustStorePath(trustStorePath);
            return this;
        }

        public Builder trustStorePassword(String trustStorePassword) {
            return this.setTrustStorePassword(trustStorePassword);
        }

        public Builder setTrustStorePassword(String trustStorePassword) {
            this.configuration.setTrustStorePassword(trustStorePassword);
            return this;
        }

        public Builder protocol(String protocol) {
            return this.setProtocol(protocol);
        }

        public Builder setProtocol(String protocol) {
            this.configuration.setProtocol(protocol);
            return this;
        }

        public Builder keyStoreType(String keyStoreType) {
            return this.setKeyStoreType(keyStoreType);
        }

        public Builder setKeyStoreType(String keyStoreType) {
            this.configuration.setKeyStoreType(keyStoreType);
            return this;
        }

        public Builder verifyHostname(boolean verifyHostname) {
            return this.setVerifyHostname(verifyHostname);
        }

        public Builder setVerifyHostname(boolean verifyHostname) {
            this.configuration.setVerifyHostname(verifyHostname);
            return this;
        }

        public SSLContextConfiguration build() {
            return this.configuration;
        }

        @Generated
        Builder() {
        }
    }
}

