/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.hibernate.usertype;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.SerializationException;
import org.hibernate.usertype.UserType;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;

public class JSONBUserType
implements UserType {
    public int[] sqlTypes() {
        return new int[]{2000};
    }

    public Class returnedClass() {
        return Object.class;
    }

    public boolean equals(Object ol, Object o2) throws HibernateException {
        return Objects.equals(ol, o2);
    }

    public int hashCode(Object obj) throws HibernateException {
        KiwiPreconditions.checkArgumentNotNull(obj, "cannot compute hashCode on null object");
        return obj.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        String columnName = names[0];
        return rs.getString(columnName);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 1111);
        } else {
            st.setObject(index, value, 1111);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        Object deepCopy = this.deepCopy(value);
        if (deepCopy instanceof Serializable) {
            return (Serializable)deepCopy;
        }
        throw new SerializationException(KiwiStrings.format("deepCopy of %s is not serializable", value), null);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }
}

