/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jackson.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class LocalDateTimeEpochTimeSerializer
extends StdSerializer<LocalDateTime> {
    private static final ZoneId UTC_ZONE = ZoneId.of("UTC");
    private final ZoneId zoneId;

    public LocalDateTimeEpochTimeSerializer() {
        this(UTC_ZONE);
    }

    public LocalDateTimeEpochTimeSerializer(ZoneId zoneId) {
        super(LocalDateTime.class);
        this.zoneId = zoneId;
    }

    public void serialize(LocalDateTime value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        jsonGenerator.writeNumber(value.atZone(this.zoneId).toInstant().toEpochMilli());
    }
}

