/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jaxrs;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiEntities {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(KiwiEntities.class);

    public static Optional<String> safeReadEntity(Response response) {
        return KiwiEntities.safeReadEntity(response, String.class);
    }

    public static String safeReadEntity(Response response, @Nullable String defaultMessage) {
        return KiwiEntities.safeReadEntity(response).orElse(defaultMessage);
    }

    public static String safeReadEntity(Response response, Supplier<String> defaultMessageSupplier) {
        KiwiPreconditions.checkArgumentNotNull(defaultMessageSupplier, "defaultMessageSupplier must not be null");
        return KiwiEntities.safeReadEntity(response).orElseGet(defaultMessageSupplier);
    }

    public static <T> Optional<T> safeReadEntity(Response response, Class<T> entityType) {
        try {
            Object entity = response.readEntity(entityType);
            return Optional.ofNullable(entity);
        }
        catch (Exception e) {
            return KiwiEntities.emptyOptional(e);
        }
    }

    public static <T> Optional<T> safeReadEntity(Response response, GenericType<T> entityType) {
        try {
            Object entity = response.readEntity(entityType);
            return Optional.ofNullable(entity);
        }
        catch (Exception e) {
            return KiwiEntities.emptyOptional(e);
        }
    }

    private static <T> Optional<T> emptyOptional(Exception e) {
        LOG.error("Error reading response entity", (Throwable)e);
        return Optional.empty();
    }

    @Generated
    private KiwiEntities() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

