/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jaxrs;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.groups.Default;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.collect.KiwiSets;
import org.kiwiproject.jaxrs.exception.JaxrsBadRequestException;
import org.kiwiproject.jaxrs.exception.JaxrsValidationException;
import org.kiwiproject.logging.LazyLogParameterSupplier;
import org.kiwiproject.validation.KiwiConstraintViolations;
import org.kiwiproject.validation.KiwiValidations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiJaxrsValidations {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(KiwiJaxrsValidations.class);
    @VisibleForTesting
    static final String MISSING_VALUE_MESSAGE = "Missing required value";

    public static <T> void assertValid(String id, T obj) {
        KiwiJaxrsValidations.assertValid(id, obj, Default.class);
    }

    public static <T> void assertValid(String id, T obj, Class<?> ... groupClasses) {
        Set<ConstraintViolation<T>> violations = KiwiValidations.validate(obj, groupClasses);
        if (KiwiSets.isNotNullOrEmpty(violations)) {
            KiwiJaxrsValidations.debugLogValidationErrors(id, obj, violations);
            throw new JaxrsValidationException(id, violations);
        }
    }

    public static <T> void assertValid(String id, T obj, Map<String, String> propertyPathMappings) {
        KiwiJaxrsValidations.assertValid(id, obj, propertyPathMappings, Default.class);
    }

    public static <T> void assertValid(String id, T obj, Map<String, String> propertyPathMappings, Class<?> ... groupClasses) {
        Set<ConstraintViolation<T>> violations = KiwiValidations.validate(obj, groupClasses);
        if (KiwiSets.isNotNullOrEmpty(violations)) {
            KiwiJaxrsValidations.debugLogValidationErrors(id, obj, violations);
            throw new JaxrsValidationException(id, violations, propertyPathMappings);
        }
    }

    private static <T> void debugLogValidationErrors(String id, T obj, Set<ConstraintViolation<T>> violations) {
        LOG.debug("Encountered validation errors for {} (id: {}): {}", new Object[]{obj.getClass().getSimpleName(), id, LazyLogParameterSupplier.lazy(() -> KiwiConstraintViolations.simpleCombinedErrorMessage(violations))});
    }

    public static void assertNotBlank(String fieldName, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new JaxrsBadRequestException(MISSING_VALUE_MESSAGE, fieldName);
        }
    }

    public static void assertNotNull(String fieldName, Object value) {
        if (Objects.isNull(value)) {
            throw new JaxrsBadRequestException(MISSING_VALUE_MESSAGE, fieldName);
        }
    }

    public static void assertTrue(boolean value, String message) {
        if (!value) {
            throw new JaxrsBadRequestException(message);
        }
    }

    @Generated
    private KiwiJaxrsValidations() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

