/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jaxrs.exception;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.collect.KiwiMaps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessage {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(ErrorMessage.class);
    public static final String KEY_CODE = "code";
    public static final String KEY_FIELD_NAME = "fieldName";
    public static final String KEY_ITEM_ID = "itemId";
    public static final String KEY_MESSAGE = "message";
    static final String DEFAULT_MSG = "Unknown error";
    static final int DEFAULT_CODE = 500;
    private final int code;
    private final String fieldName;
    private final String itemId;
    private final String message;

    public ErrorMessage(String message) {
        this(null, 500, message, null);
    }

    public ErrorMessage(Response.Status status, String message) {
        this(null, status.getStatusCode(), message, null);
    }

    public ErrorMessage(int code, String message) {
        this(null, code, message, null);
    }

    public ErrorMessage(int code, String message, String fieldName) {
        this(null, code, message, fieldName);
    }

    @ConstructorProperties(value={"itemId", "code", "message", "fieldName"})
    public ErrorMessage(String itemId, int code, String message, String fieldName) {
        this.itemId = itemId;
        this.code = code <= 0 ? 500 : code;
        this.message = StringUtils.isBlank((CharSequence)message) ? DEFAULT_MSG : message;
        this.fieldName = fieldName;
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(KiwiMaps.newHashMap(KEY_MESSAGE, this.message, KEY_CODE, this.code, KEY_FIELD_NAME, this.fieldName, KEY_ITEM_ID, this.itemId));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(KEY_CODE, this.code).add(KEY_MESSAGE, (Object)this.message).add(KEY_FIELD_NAME, (Object)this.fieldName).add(KEY_ITEM_ID, (Object)this.itemId).toString();
    }

    public static ErrorMessage valueOf(Map<String, Object> props) {
        String messageOrDefault = (String)props.getOrDefault(KEY_MESSAGE, DEFAULT_MSG);
        String message = StringUtils.isBlank((CharSequence)messageOrDefault) ? DEFAULT_MSG : messageOrDefault;
        String itemId = (String)props.get(KEY_ITEM_ID);
        String fieldName = (String)props.get(KEY_FIELD_NAME);
        int code = 500;
        if (props.containsKey(KEY_CODE)) {
            try {
                code = (Integer)props.get(KEY_CODE);
            }
            catch (Exception e) {
                LOG.error("Invalid code in properties: {}", props, (Object)e);
            }
        }
        return new ErrorMessage(itemId, code, message, fieldName);
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public String getFieldName() {
        return this.fieldName;
    }

    @Generated
    public String getItemId() {
        return this.itemId;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorMessage)) {
            return false;
        }
        ErrorMessage other = (ErrorMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$itemId = this.getItemId();
        String other$itemId = other.getItemId();
        if (this$itemId == null ? other$itemId != null : !this$itemId.equals(other$itemId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ErrorMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $itemId = this.getItemId();
        result = result * 59 + ($itemId == null ? 43 : $itemId.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }
}

