/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jaxws;

import java.net.URI;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.BindingProvider;
import lombok.Generated;

public final class KiwiJaxWs {
    public static final int JAX_WS_DEFAULT_CONNECT_TIMEOUT_MILLIS = 5000;
    public static final int JAX_WS_DEFAULT_READ_TIMEOUT_MILLIS = 5000;

    public static <T> T configureJdkWebServiceWithDefaultTimeouts(Class<T> clazz, BindingProvider bindingProvider, String serviceEndpointUri, SSLSocketFactory sslSocketFactory) {
        return KiwiJaxWs.configureJdkWebService(clazz, bindingProvider, serviceEndpointUri, sslSocketFactory, 5000, 5000);
    }

    public static <T> T configureJdkWebService(Class<T> clazz, BindingProvider bindingProvider, String serviceEndpointUri, SSLSocketFactory sslSocketFactory, int connectTimeoutMillis, int readTimeoutMillis) {
        KiwiJaxWs.configureJdkWebServiceSslSocketFactory(bindingProvider, sslSocketFactory);
        KiwiJaxWs.configureJdkWebServiceConnectTimeout(bindingProvider, connectTimeoutMillis);
        KiwiJaxWs.configureJdkWebServiceReadTimeout(bindingProvider, readTimeoutMillis);
        KiwiJaxWs.configureJdkWebServiceEndpointAddress(bindingProvider, serviceEndpointUri);
        return clazz.cast(bindingProvider);
    }

    public static void configureJdkWebServiceSslSocketFactory(BindingProvider bindingProvider, SSLSocketFactory sslSocketFactory) {
        bindingProvider.getRequestContext().put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", sslSocketFactory);
    }

    public static void configureJdkWebServiceDefaultConnectTimeout(BindingProvider bindingProvider) {
        KiwiJaxWs.configureJdkWebServiceConnectTimeout(bindingProvider, 5000);
    }

    public static void configureJdkWebServiceConnectTimeout(BindingProvider bindingProvider, int connectTimeoutMillis) {
        bindingProvider.getRequestContext().put("com.sun.xml.ws.connect.timeout", connectTimeoutMillis);
    }

    public static void configureJdkWebServiceDefaultReadTimeout(BindingProvider bindingProvider) {
        KiwiJaxWs.configureJdkWebServiceReadTimeout(bindingProvider, 5000);
    }

    public static void configureJdkWebServiceReadTimeout(BindingProvider bindingProvider, int readTimeoutMillis) {
        bindingProvider.getRequestContext().put("com.sun.xml.ws.request.timeout", readTimeoutMillis);
    }

    public static void configureJdkWebServiceEndpointAddress(BindingProvider bindingProvider, String serviceEndpointUri) {
        bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", serviceEndpointUri);
    }

    public static void configureJdkWebServiceEndpointAddress(BindingProvider bindingProvider, URI serviceEndpointUri) {
        KiwiJaxWs.configureJdkWebServiceEndpointAddress(bindingProvider, serviceEndpointUri.toString());
    }

    @Generated
    private KiwiJaxWs() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

