/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jsch;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.Session;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;

public final class KiwiJSchHelpers {
    public static Optional<String> detectKeyExchangeTypeForHost(String host, HostKeyRepository knownHosts) {
        KiwiPreconditions.checkArgumentNotBlank(host);
        KiwiPreconditions.checkArgumentNotNull(knownHosts);
        return Arrays.stream(knownHosts.getHostKey()).filter(knownHost -> KiwiJSchHelpers.hostMatchesKnownHost(host, knownHost)).map(HostKey::getType).findFirst();
    }

    public static void setSessionKeyExchangeType(Session session, String keyExchangeType) {
        KiwiPreconditions.checkArgumentNotNull(session);
        KiwiPreconditions.checkArgumentNotBlank(keyExchangeType);
        session.setConfig("server_host_key", keyExchangeType);
    }

    private static boolean hostMatchesKnownHost(String hostOrIpToFind, HostKey hostKey) {
        KnownHost knownHost = new KnownHost(hostKey);
        if (InetAddresses.isInetAddress((String)hostOrIpToFind)) {
            return hostOrIpToFind.equals(knownHost.ipAddress);
        }
        return hostOrIpToFind.equals(knownHost.hostName);
    }

    @Generated
    private KiwiJSchHelpers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class KnownHost {
        final String hostName;
        final String ipAddress;

        KnownHost(HostKey knownHost) {
            String host = knownHost.getHost();
            if (KnownHost.containsCommaSeparatedHostAndIpAddress(host)) {
                String[] splat = host.split(",");
                Preconditions.checkState((splat.length > 1 ? 1 : 0) != 0, (Object)"Expecting host key to be in format: hostName,IP");
                this.hostName = splat[0];
                this.ipAddress = splat[1];
            } else {
                this.hostName = host;
                this.ipAddress = null;
            }
        }

        private static boolean containsCommaSeparatedHostAndIpAddress(String value) {
            return value.contains(",");
        }
    }
}

