/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jsch;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Vector;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.kiwiproject.jsch.JSchSlf4jLogger;
import org.kiwiproject.jsch.SftpConnector;
import org.slf4j.LoggerFactory;

public class SftpTransfers {
    @Generated
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(SftpTransfers.class);
    private final SftpConnector connector;

    public SftpTransfers(SftpConnector connector) {
        this.connector = connector;
    }

    public void connect() {
        this.connector.connect();
    }

    public void disconnect() {
        this.connector.disconnect();
    }

    public void putFile(Path remotePath, String filename, InputStream data) {
        this.connector.runCommand(channel -> {
            SftpTransfers.changeOrCreateRemoteDirectory(channel, remotePath);
            channel.put(data, filename);
        });
    }

    private static void changeOrCreateRemoteDirectory(ChannelSftp channel, Path path) throws SftpException {
        try {
            SftpTransfers.changeToRemoteDirectory(channel, path);
        }
        catch (SftpException e) {
            LOG.debug("Directory {} did not exist. Will create it", (Object)path, (Object)e);
            channel.mkdir(path.toString());
            SftpTransfers.changeToRemoteDirectory(channel, path);
        }
    }

    public void getAndStoreAllFiles(Path remotePath, BiFunction<Path, String, Path> localPathSupplier, BiFunction<Path, String, String> localFilenameSupplier) {
        this.listFiles(remotePath).forEach(filename -> this.getAndStoreFile(remotePath, localPathSupplier, (String)filename, localFilenameSupplier));
        this.listDirectories(remotePath).forEach(directory -> this.getAndStoreAllFiles(remotePath.resolve((String)directory), localPathSupplier, localFilenameSupplier));
    }

    public void getAndStoreFile(Path remotePath, Path localPath, String filename) {
        this.getAndStoreFile(remotePath, localPath, filename, filename);
    }

    public void getAndStoreFile(Path remotePath, Path localPath, String remoteFilename, String localFilename) {
        this.getAndStoreFile(remotePath, (Path rPath, String rFile) -> localPath, remoteFilename, (Path rPath, String rFile) -> localFilename);
    }

    public void getAndStoreFile(Path remotePath, BiFunction<Path, String, Path> localPathSupplier, String remoteFilename, BiFunction<Path, String, String> localFilenameSupplier) {
        this.connector.runCommand(channel -> {
            SftpTransfers.changeToRemoteDirectory(channel, remotePath);
            Path localPath = (Path)localPathSupplier.apply(remotePath, remoteFilename);
            SftpTransfers.ensureLocalDirectoryExists(localPath);
            try (InputStream inputStream = channel.get(remoteFilename);){
                Path resolvedLocalPath = localPath.resolve((String)localFilenameSupplier.apply(remotePath, remoteFilename));
                Files.copy(inputStream, resolvedLocalPath, StandardCopyOption.REPLACE_EXISTING);
            }
        });
    }

    private static void ensureLocalDirectoryExists(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            LOG.debug("Local storage directory {} doesn't exist. Creating.", (Object)path);
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    public String getFileContent(Path remotePath, String remoteFilename) {
        return this.connector.runCommandWithResponse(channel -> {
            SftpTransfers.changeToRemoteDirectory(channel, remotePath);
            try (InputStream inputStream = channel.get(remoteFilename);){
                InputStreamReader streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                StringWriter stringWriter = new StringWriter();
                streamReader.transferTo(stringWriter);
                String string = stringWriter.toString();
                return string;
            }
        });
    }

    public InputStream getFileContentAsInputStream(Path remotePath, String remoteFilename) {
        return this.connector.runCommandWithResponse(channel -> {
            SftpTransfers.changeToRemoteDirectory(channel, remotePath);
            return channel.get(remoteFilename);
        });
    }

    public List<String> listFiles(Path remotePath) {
        return this.listRemoteItems(remotePath, file -> !file.getAttrs().isDir());
    }

    public List<String> listFiles(Path remotePath, Predicate<String> fileFilter) {
        return this.listFiles(remotePath).stream().filter(fileFilter).collect(Collectors.toList());
    }

    public List<String> listDirectories(Path remotePath) {
        return this.listRemoteItems(remotePath, file -> file.getAttrs().isDir());
    }

    public List<String> listDirectories(Path remotePath, Predicate<String> dirFilter) {
        return this.listDirectories(remotePath).stream().filter(dirFilter).collect(Collectors.toList());
    }

    private List<String> listRemoteItems(Path remotePath, Predicate<ChannelSftp.LsEntry> filterFunction) {
        return this.connector.runCommandWithResponse(channel -> SftpTransfers.ls(channel, remotePath).stream().filter(filterFunction).map(ChannelSftp.LsEntry::getFilename).collect(Collectors.toList()));
    }

    private static Vector<ChannelSftp.LsEntry> ls(ChannelSftp channel, Path remotePath) throws SftpException {
        return channel.ls(remotePath.toString());
    }

    public void deleteRemoteFile(Path remotePath, String remoteFilename) {
        this.connector.runCommand(channel -> {
            SftpTransfers.changeToRemoteDirectory(channel, remotePath);
            channel.rm(remoteFilename);
        });
    }

    private static void changeToRemoteDirectory(ChannelSftp channel, Path path) throws SftpException {
        LOG.debug("Attempting to change to {} on the remote host", (Object)path);
        channel.cd(path.toString());
        LOG.debug("Successfully changed directory on the remote host");
    }

    static {
        JSch.setLogger((Logger)new JSchSlf4jLogger(LOG));
    }
}

