/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.json;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.kiwiproject.json.PropertyMaskingOptions;
import org.kiwiproject.json.PropertyMaskingSafePropertyWriter;

public final class KiwiJacksonSerializers {
    public static SimpleModule buildPropertyMaskingSafeSerializerModule(List<String> maskedFieldRegexps) {
        PropertyMaskingOptions options = PropertyMaskingOptions.builder().maskedFieldRegexps(maskedFieldRegexps).build();
        return KiwiJacksonSerializers.buildPropertyMaskingSafeSerializerModule(options);
    }

    public static SimpleModule buildPropertyMaskingSafeSerializerModule(final PropertyMaskingOptions options) {
        BeanSerializerModifier modifier = new BeanSerializerModifier(){

            public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
                return beanProperties.stream().map(beanPropertyWriter -> new PropertyMaskingSafePropertyWriter((BeanPropertyWriter)beanPropertyWriter, options)).collect(Collectors.toList());
            }
        };
        return new SimpleModule().setSerializerModifier(modifier);
    }

    @Generated
    private KiwiJacksonSerializers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

