/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.security;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.collect.KiwiMaps;
import org.kiwiproject.security.KiwiSecurity;
import org.kiwiproject.security.SSLContextException;

public class SimpleSSLContextFactory {
    private static final String KEY_STORE_PATH_PROPERTY = "keyStorePath";
    private static final String KEY_STORE_PASSWORD_PROPERTY = "keyStorePassword";
    private static final String TRUST_STORE_PATH_PROPERTY = "trustStorePath";
    private static final String TRUST_STORE_PASSWORD_PROPERTY = "trustStorePassword";
    private static final String PROTOCOL_PROPERTY = "protocol";
    private static final String VERIFY_HOSTNAME_PROPERTY = "verifyHostname";
    private static final List<String> REQUIRED_PROPERTIES = List.of("trustStorePath", "trustStorePassword", "protocol");
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String protocol;
    private SSLContext sslContext;
    private final boolean verifyHostname;

    public SimpleSSLContextFactory(String keyStorePath, String keyStorePassword, String trustStorePath, String trustStorePassword, String protocol) {
        this(keyStorePath, keyStorePassword, trustStorePath, trustStorePassword, protocol, true);
    }

    public SimpleSSLContextFactory(String keyStorePath, String keyStorePassword, String trustStorePath, String trustStorePassword, String protocol, boolean verifyHostname) {
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.protocol = protocol;
        this.verifyHostname = verifyHostname;
    }

    public static Builder builder() {
        return new Builder();
    }

    public synchronized SSLContext getSslContext() {
        if (Objects.isNull(this.sslContext)) {
            this.sslContext = KiwiSecurity.createSslContext(this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword, this.protocol);
        }
        return this.sslContext;
    }

    @Generated
    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    public static class Builder {
        private final Map<String, Optional<String>> entries = KiwiMaps.newHashMap("keyStorePath", Optional.empty(), "keyStorePassword", Optional.empty(), "trustStorePath", Optional.empty(), "trustStorePassword", Optional.empty(), "protocol", Optional.empty(), "verifyHostname", Optional.empty());

        protected Builder() {
        }

        public Builder keyStorePath(String keyStorePath) {
            return this.setKeyStorePath(keyStorePath);
        }

        public Builder setKeyStorePath(String keyStorePath) {
            this.entries.put(SimpleSSLContextFactory.KEY_STORE_PATH_PROPERTY, Optional.of(keyStorePath));
            return this;
        }

        public Builder keyStorePassword(String keyStorePassword) {
            return this.setKeyStorePassword(keyStorePassword);
        }

        public Builder setKeyStorePassword(String keyStorePassword) {
            this.entries.put(SimpleSSLContextFactory.KEY_STORE_PASSWORD_PROPERTY, Optional.of(keyStorePassword));
            return this;
        }

        public Builder trustStorePath(String trustStorePath) {
            return this.setTrustStorePath(trustStorePath);
        }

        public Builder setTrustStorePath(String trustStorePath) {
            this.entries.put(SimpleSSLContextFactory.TRUST_STORE_PATH_PROPERTY, Optional.of(trustStorePath));
            return this;
        }

        public Builder trustStorePassword(String trustStorePassword) {
            return this.setTrustStorePassword(trustStorePassword);
        }

        public Builder setTrustStorePassword(String trustStorePassword) {
            this.entries.put(SimpleSSLContextFactory.TRUST_STORE_PASSWORD_PROPERTY, Optional.of(trustStorePassword));
            return this;
        }

        public Builder protocol(String protocol) {
            return this.setProtocol(protocol);
        }

        public Builder setProtocol(String protocol) {
            this.entries.put(SimpleSSLContextFactory.PROTOCOL_PROPERTY, Optional.of(protocol));
            return this;
        }

        public Builder verifyHostname(boolean verifyHostname) {
            return this.setVerifyHostname(verifyHostname);
        }

        public Builder setVerifyHostname(boolean verifyHostname) {
            this.entries.put(SimpleSSLContextFactory.VERIFY_HOSTNAME_PROPERTY, Optional.of(String.valueOf(verifyHostname)));
            return this;
        }

        public SimpleSSLContextFactory build() {
            this.validateBuilderState();
            return new SimpleSSLContextFactory(this.entries.get(SimpleSSLContextFactory.KEY_STORE_PATH_PROPERTY).orElse(null), this.entries.get(SimpleSSLContextFactory.KEY_STORE_PASSWORD_PROPERTY).orElse(null), this.entries.get(SimpleSSLContextFactory.TRUST_STORE_PATH_PROPERTY).orElseThrow(IllegalStateException::new), this.entries.get(SimpleSSLContextFactory.TRUST_STORE_PASSWORD_PROPERTY).orElseThrow(IllegalStateException::new), this.entries.get(SimpleSSLContextFactory.PROTOCOL_PROPERTY).orElseThrow(IllegalStateException::new), Boolean.parseBoolean(this.entries.get(SimpleSSLContextFactory.VERIFY_HOSTNAME_PROPERTY).orElse("true")));
        }

        public void validateBuilderState() {
            this.entries.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isEmpty()).filter(entry -> REQUIRED_PROPERTIES.contains(entry.getKey())).findAny().ifPresent(entry -> Builder.throwBuildException((String)entry.getKey()));
        }

        private static void throwBuildException(String property) {
            throw new SSLContextException(KiwiStrings.f("Required property '{}' not set; cannot build SimpleSSLContextFactory", property));
        }
    }
}

