/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.spring.context;

import com.mongodb.WriteConcern;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.kiwiproject.spring.data.KiwiMongoConverters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDbFactory;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactory;

public class MongoRepositoryContext {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(MongoRepositoryContext.class);
    private final MongoTemplate mongoTemplate;
    private final MongoRepositoryFactory factory;
    private final GenericApplicationContext springContext;
    private final ConcurrentMap<Class<?>, MongoRepository<?, ?>> repoMap = new ConcurrentHashMap();

    public MongoRepositoryContext(String mongoUri) {
        this(MongoRepositoryContext.initializeMongoTemplate(mongoUri));
    }

    public MongoRepositoryContext(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
        this.factory = new MongoRepositoryFactory((MongoOperations)mongoTemplate);
        this.springContext = new GenericApplicationContext();
        this.springContext.refresh();
        this.mongoTemplate.setApplicationContext((ApplicationContext)this.springContext);
    }

    public final <T extends MongoRepository<?, ?>> T getRepository(Class<T> repositoryInterfaceClass) {
        return (T)this.repoMap.computeIfAbsent(repositoryInterfaceClass, missingClass -> (MongoRepository)this.factory.getRepository(missingClass));
    }

    public void attachListeners(ApplicationListener<?> ... listeners) {
        Set registeredListenerClassNames = this.springContext.getApplicationListeners().stream().map(listener -> listener.getClass().getName()).collect(Collectors.toSet());
        Stream.of(listeners).forEach(listener -> {
            String listenerClassName = listener.getClass().getName();
            LOG.debug("Adding application listener: {}", (Object)listenerClassName);
            if (registeredListenerClassNames.contains(listenerClassName)) {
                LOG.warn("There is already listener of type of {}; adding another one may cause unintended consequences", (Object)listenerClassName);
            }
            this.springContext.addApplicationListener(listener);
        });
    }

    public static MongoTemplate initializeMongoTemplate(String mongoUri) {
        SimpleMongoClientDbFactory mongoDbFactory = new SimpleMongoClientDbFactory(mongoUri);
        MongoTemplate mongoTemplate = new MongoTemplate((MongoDbFactory)mongoDbFactory);
        mongoTemplate.setWriteConcern(WriteConcern.ACKNOWLEDGED);
        KiwiMongoConverters.addCustomConverters(mongoTemplate, KiwiMongoConverters.newBsonUndefinedToNullObjectConverter());
        return mongoTemplate;
    }

    @Generated
    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Generated
    public MongoRepositoryFactory getFactory() {
        return this.factory;
    }

    @Generated
    public GenericApplicationContext getSpringContext() {
        return this.springContext;
    }
}

