/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.spring.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KiwiSort {
    private String direction;
    private String property;
    private boolean ignoreCase;
    private boolean ascending;

    public static KiwiSort of(String property, Direction direction) {
        KiwiPreconditions.checkArgumentNotBlank(property);
        KiwiPreconditions.checkArgumentNotNull(direction);
        KiwiSort sort = new KiwiSort();
        sort.setProperty(property);
        sort.setDirection(direction.name());
        sort.setAscending(direction.isAscending());
        sort.setIgnoreCase(false);
        return sort;
    }

    public KiwiSort ignoringCase() {
        this.setIgnoreCase(true);
        return this;
    }

    @Generated
    public String getDirection() {
        return this.direction;
    }

    @Generated
    public String getProperty() {
        return this.property;
    }

    @Generated
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Generated
    public boolean isAscending() {
        return this.ascending;
    }

    @Generated
    public void setDirection(String direction) {
        this.direction = direction;
    }

    @Generated
    public void setProperty(String property) {
        this.property = property;
    }

    @Generated
    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Generated
    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    @Generated
    public String toString() {
        return "KiwiSort(direction=" + this.getDirection() + ", property=" + this.getProperty() + ", ignoreCase=" + this.isIgnoreCase() + ", ascending=" + this.isAscending() + ")";
    }

    public static enum Direction {
        ASC(true),
        DESC(false);

        public final boolean ascending;

        private Direction(boolean ascending) {
            this.ascending = ascending;
        }

        @Generated
        public boolean isAscending() {
            return this.ascending;
        }
    }
}

