/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.spring.data;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.spring.data.AggregateResult;
import org.kiwiproject.spring.data.KiwiPaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.FacetOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

public class PagingQuery
extends Query {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(PagingQuery.class);
    private final MongoTemplate mongoTemplate;
    private Pageable pageable;
    private static final ConcurrentMap<Class<?>, AggregateResult<?>> CLASS_WRAPPERS = new ConcurrentHashMap();

    public PagingQuery(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public PagingQuery with(Pageable pageable) {
        this.pageable = pageable;
        super.with(pageable);
        return this;
    }

    public <T> Page<T> findPage(Class<T> clazz) {
        KiwiPreconditions.checkArgumentNotNull(clazz);
        this.checkPageableNotNull();
        Pageable unlimitedPageable = KiwiPaging.createPageable(0, Integer.MAX_VALUE, new Object[0]);
        Query unpagedQuery = Query.of((Query)this).with(unlimitedPageable);
        long count = this.mongoTemplate.count(unpagedQuery, clazz);
        List results = this.mongoTemplate.find((Query)this, clazz);
        return new PageImpl(results, this.pageable, count);
    }

    @Beta
    public <T> Page<T> aggregatePage(Class<T> clazz, AggregationOperation ... aggregationOps) {
        KiwiPreconditions.checkArgumentNotNull(clazz);
        this.checkPageableNotNull();
        LOG.debug("Preparing aggregation query for class: {}", clazz);
        List<AggregationOperation> aggregations = this.buildNewAggregationWithOps(aggregationOps);
        aggregations.add((AggregationOperation)this.buildResultFacet());
        aggregations.add((AggregationOperation)PagingQuery.buildResultProjection());
        Class<AggregateResult<T>> wrappedClass = this.getClassWrapper(clazz);
        TypedAggregation typedAggregation = new TypedAggregation(wrappedClass, aggregations);
        LOG.debug("Executing aggregation query: {}", (Object)typedAggregation);
        try {
            AggregationResults<AggregateResult<T>> aggregationResults = this.executeAggregationQuery(clazz, wrappedClass, typedAggregation);
            return this.convertToPage(aggregationResults);
        }
        catch (Exception ex) {
            LOG.error("Encountered error performing aggregation query", (Throwable)ex);
            throw ex;
        }
    }

    private void checkPageableNotNull() {
        Preconditions.checkState((boolean)Objects.nonNull(this.pageable), (Object)"this.pageable cannot be null; call with(Pageable) first");
    }

    private List<AggregationOperation> buildNewAggregationWithOps(AggregationOperation[] aggregationOps) {
        ArrayList<AggregationOperation> aggregations = new ArrayList<AggregationOperation>();
        if (KiwiLists.isNotNullOrEmpty(this.getCriteria())) {
            MatchOperation matchOperation = Aggregation.match((Criteria)new Criteria().andOperator((Criteria[])this.getCriteria().toArray(Criteria[]::new)));
            aggregations.add((AggregationOperation)matchOperation);
        }
        if (Objects.nonNull(aggregationOps)) {
            List aggregationOpList = Lists.newArrayList((Object[])aggregationOps).stream().filter(Objects::nonNull).collect(Collectors.toList());
            aggregations.addAll(aggregationOpList);
        }
        return aggregations;
    }

    private FacetOperation buildResultFacet() {
        return Aggregation.facet((AggregationOperation[])this.buildPagingOperations()).as("results").and(new AggregationOperation[]{Aggregation.count().as("count")}).as("totalCount");
    }

    private AggregationOperation[] buildPagingOperations() {
        return new AggregationOperation[]{Aggregation.sort((Sort)this.pageable.getSort()), Aggregation.skip((long)this.getSkip()), Aggregation.limit((long)this.getLimit())};
    }

    private static ProjectionOperation buildResultProjection() {
        return Aggregation.project((String[])new String[]{"results"}).and("totalCount.count").arrayElementAt(0).as("totalCount");
    }

    private <T> Class<? extends AggregateResult<T>> getClassWrapper(Class<T> clazz) {
        AggregateResult resultClass = CLASS_WRAPPERS.computeIfAbsent(clazz, AggregateResult::of);
        return resultClass.getClass();
    }

    @VisibleForTesting
    private <T> AggregationResults<? extends AggregateResult<T>> executeAggregationQuery(Class<T> clazz, Class<? extends AggregateResult<T>> wrappedClass, TypedAggregation<? extends AggregateResult<T>> typedAggregation) {
        return this.mongoTemplate.aggregate(typedAggregation, clazz, wrappedClass);
    }

    private <T> PageImpl<T> convertToPage(AggregationResults<? extends AggregateResult<T>> aggregateResults) {
        AggregateResult result = (AggregateResult)aggregateResults.getUniqueMappedResult();
        if (Objects.isNull(result)) {
            LOG.warn("Received a NULL result from aggregation query");
            throw new IllegalStateException("Query failed to obtain an aggregate result");
        }
        return new PageImpl(result.getResults(), this.pageable, result.getTotalCount());
    }
}

