/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import lombok.Generated;
import org.kiwiproject.logging.LazyLogParameterSupplier;
import org.kiwiproject.validation.DirectoryPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryPathValidator
implements ConstraintValidator<DirectoryPath, String> {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryPathValidator.class);
    private DirectoryPath directoryPath;

    public void initialize(DirectoryPath constraintAnnotation) {
        this.directoryPath = constraintAnnotation;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (Objects.isNull(value)) {
            return this.directoryPath.allowNull();
        }
        try {
            File file = Path.of(value, new String[0]).toFile();
            LOG.trace("Validating access to directory: {}", LazyLogParameterSupplier.lazy(file::getAbsolutePath));
            boolean exists = file.exists();
            boolean directoryCreated = this.createDirectoryIfNecessary(file, exists);
            boolean directoryExistsOrWasCreated = exists || directoryCreated;
            return directoryExistsOrWasCreated && file.isDirectory() && this.isReadableOrIgnoresEnsureReadable(file) && this.isWritableOrIgnoresEnsureReadable(file);
        }
        catch (Exception e) {
            String hasNulCharacter = value.contains("\u0000") ? " Path contains Nul character!" : "";
            LOG.warn("Exception thrown validating path [{}].{}", new Object[]{value, hasNulCharacter, e});
            return false;
        }
    }

    private boolean createDirectoryIfNecessary(File file, boolean exists) {
        if (exists || !this.directoryPath.mkdirs()) {
            return false;
        }
        String absolutePath = file.getAbsolutePath();
        LOG.info("Directory does not exist and 'mkdirs' option is true. Creating directory: {}", (Object)absolutePath);
        boolean created = file.mkdirs();
        if (!created) {
            LOG.error("Unable to create directory: {}", (Object)absolutePath);
        }
        return created;
    }

    private boolean isReadableOrIgnoresEnsureReadable(File file) {
        return !this.directoryPath.ensureReadable() || file.canRead();
    }

    private boolean isWritableOrIgnoresEnsureReadable(File file) {
        return !this.directoryPath.ensureWritable() || file.canWrite();
    }
}

