/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import lombok.Generated;
import org.kiwiproject.validation.FilePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePathValidator
implements ConstraintValidator<FilePath, String> {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(FilePathValidator.class);
    private FilePath filePath;

    public void initialize(FilePath constraintAnnotation) {
        this.filePath = constraintAnnotation;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (Objects.isNull(value)) {
            return this.filePath.allowNull();
        }
        try {
            File file = Path.of(value, new String[0]).toFile();
            return file.exists() && file.isFile();
        }
        catch (Exception e) {
            LOG.warn("Exception thrown validating path [{}]", (Object)value, (Object)e);
            return false;
        }
    }
}

