/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.validation.Ipv4Address;

public class Ipv4AddressValidator
implements ConstraintValidator<Ipv4Address, String> {
    private static final String IPV4_REGEX = "^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$";
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");
    private static final int IPV4_MAX_OCTET_VALUE = 255;
    private static final int INVALID_IP_SEGMENT = -1;
    private Ipv4Address ipv4Address;

    public void initialize(Ipv4Address constraintAnnotation) {
        this.ipv4Address = constraintAnnotation;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (Objects.isNull(value)) {
            return this.ipv4Address.allowNull();
        }
        Matcher matcher = IPV4_PATTERN.matcher(value);
        if (!matcher.matches()) {
            return false;
        }
        Stream<String> segments = this.segmentsOf(matcher);
        return this.allSegmentsAreValid(segments);
    }

    private Stream<String> segmentsOf(Matcher matcher) {
        return IntStream.rangeClosed(1, matcher.groupCount()).mapToObj(matcher::group).collect(Collectors.toList()).stream();
    }

    private boolean allSegmentsAreValid(Stream<String> segmentStream) {
        long invalidSegmentCount = segmentStream.mapToInt(Ipv4AddressValidator::ipSegmentAsInt).filter(Ipv4AddressValidator::isInvalidIpSegment).count();
        return invalidSegmentCount == 0L;
    }

    @VisibleForTesting
    static int ipSegmentAsInt(String ipSegment) {
        if (StringUtils.isBlank((CharSequence)ipSegment)) {
            return -1;
        }
        if (Ipv4AddressValidator.hasMoreThanOneDigitStartingWithZero(ipSegment)) {
            return -1;
        }
        try {
            return Integer.parseInt(ipSegment);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static boolean hasMoreThanOneDigitStartingWithZero(String ipSegment) {
        return ipSegment.length() > 1 && ipSegment.startsWith("0");
    }

    @VisibleForTesting
    static boolean isInvalidIpSegment(int ipSegment) {
        return ipSegment < 0 || ipSegment > 255;
    }
}

