/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import com.google.common.base.Verify;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import lombok.Generated;
import org.kiwiproject.validation.InternalKiwiValidators;
import org.kiwiproject.validation.KiwiValidations;
import org.kiwiproject.validation.Range;
import org.kiwiproject.validation.Validity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeValidator
implements ConstraintValidator<Range, Object> {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(RangeValidator.class);
    private static final String TEMPLATE_BETWEEN = "{org.kiwiproject.validation.Range.between.message}";
    private static final String TEMPLATE_LESS_THAN_OR_EQ = "{org.kiwiproject.validation.Range.lessThanOrEq.message}";
    private static final String TEMPLATE_GREATER_THAN_OR_EQ = "{org.kiwiproject.validation.Range.greaterThanOrEq.message}";
    private Range range;

    public void initialize(Range constraintAnnotation) {
        this.range = constraintAnnotation;
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        Validity validity;
        try {
            validity = this.checkNull(value, context);
            if (validity == Validity.CONTINUE) {
                validity = this.checkMinMax((Comparable)value, context);
            }
        }
        catch (Exception e) {
            KiwiValidations.addError(context, "unknown validation error");
            RangeValidator.logWarning(value, e);
            validity = Validity.INVALID;
        }
        return validity == Validity.VALID;
    }

    private Validity checkNull(Object value, ConstraintValidatorContext context) {
        if (Objects.isNull(value)) {
            if (this.range.allowNull()) {
                return Validity.VALID;
            }
            KiwiValidations.addError(context, "{org.kiwiproject.validation.Required.message}");
            return Validity.INVALID;
        }
        return Validity.CONTINUE;
    }

    private Validity checkMinMax(Comparable<Object> value, ConstraintValidatorContext context) {
        Verify.verify((boolean)Objects.nonNull(value), (String)"value should not be null at this point (checkNull should have returned INVALID)!", (Object[])new Object[0]);
        Comparable<Object> min = InternalKiwiValidators.toComparableOrNull(this.range.min(), value);
        Comparable<Object> max = InternalKiwiValidators.toComparableOrNull(this.range.max(), value);
        if (RangeValidator.hasBothMinAndMax(min, max) && RangeValidator.outsideRange(min, max, value)) {
            KiwiValidations.addError(context, TEMPLATE_BETWEEN);
            return Validity.INVALID;
        }
        return RangeValidator.checkMinOrMax(context, min, max, value);
    }

    private static boolean hasBothMinAndMax(Comparable<?> min, Comparable<?> max) {
        return Objects.nonNull(min) && Objects.nonNull(max);
    }

    private static boolean outsideRange(Comparable<?> min, Comparable<?> max, Comparable<Object> value) {
        return value.compareTo(min) < 0 || value.compareTo(max) > 0;
    }

    private static Validity checkMinOrMax(ConstraintValidatorContext context, Comparable<?> min, Comparable<?> max, Comparable<Object> value) {
        if (Objects.nonNull(min) && value.compareTo(min) < 0) {
            KiwiValidations.addError(context, TEMPLATE_GREATER_THAN_OR_EQ);
            return Validity.INVALID;
        }
        if (Objects.nonNull(max) && value.compareTo(max) > 0) {
            KiwiValidations.addError(context, TEMPLATE_LESS_THAN_OR_EQ);
            return Validity.INVALID;
        }
        return Validity.VALID;
    }

    private static void logWarning(Object value, Exception e) {
        if (value instanceof Comparable) {
            LOG.warn("Error validating Range for value: {} ; considering as invalid", value, (Object)e);
        } else {
            LOG.warn("Error validating Range for value that does not implement Comparable: {} ; considering as invalid", value, (Object)e);
        }
    }
}

