/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.ansible.vault;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiLists;

class VaultEncryptedVariable {
    private static final String INVALID_ENCRYPT_STRING_INPUT = "Input does not appear to be valid encrypt_string content";
    private static final String INVALID_VARIABLE_NAME_DECLARATION = "First line does not have a valid variable name declaration";
    private static final String INVALID_ANSIBLE_VAULT_DECLARATION = "Second line does not have a valid $ANSIBLE_VAULT declaration";
    private static final String INVALID_SPACING_IN_ENCRYPTED_CONTENT = "Encrypted content does not start with 10 spaces";
    private static final String INVALID_FORMAT_IN_ENCRYPTED_CONTENT = "Encrypted content is not longer than 10 characters or has more than 10 spaces before encrypted content";
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private String variableName;
    private String formatVersion;
    private String cipher;
    private String vaultIdLabel;
    private List<String> encryptedContentLines;
    private final String encryptedFileContent;

    VaultEncryptedVariable(String encryptedString) {
        KiwiPreconditions.checkArgumentNotBlank(encryptedString, "encryptedString cannot be blank");
        this.parse(encryptedString);
        this.encryptedFileContent = this.buildEncryptedFileContent();
    }

    private void parse(String encryptStringOutput) {
        List<String> lines = encryptStringOutput.lines().collect(Collectors.toUnmodifiableList());
        Preconditions.checkArgument((lines.size() > 2 ? 1 : 0) != 0, (Object)INVALID_ENCRYPT_STRING_INPUT);
        this.parseLine1(lines);
        this.parseLine2(lines);
        this.parseRemainingLines(lines);
    }

    private void parseLine1(List<String> lines) {
        String first = KiwiLists.first(lines);
        Preconditions.checkArgument((boolean)first.endsWith(": !vault |"), (Object)INVALID_VARIABLE_NAME_DECLARATION);
        this.variableName = first.split(":")[0];
    }

    private void parseLine2(List<String> lines) {
        String second = KiwiLists.second(lines);
        Preconditions.checkArgument((boolean)second.contains(";"), (Object)INVALID_ANSIBLE_VAULT_DECLARATION);
        String[] splat = second.split(";");
        Preconditions.checkArgument((VaultEncryptedVariable.line2HasValidLength(splat) && VaultEncryptedVariable.line2HasValidPrefix(splat[0]) ? 1 : 0) != 0, (Object)INVALID_ANSIBLE_VAULT_DECLARATION);
        Preconditions.checkArgument((boolean)VaultEncryptedVariable.isValidFormatVersion(splat[1]), (Object)INVALID_ANSIBLE_VAULT_DECLARATION);
        this.formatVersion = splat[1];
        KiwiPreconditions.checkArgumentNotBlank(splat[2], INVALID_ANSIBLE_VAULT_DECLARATION);
        this.cipher = splat[2];
        if (splat.length == 4) {
            KiwiPreconditions.checkArgumentNotBlank(splat[3], INVALID_ANSIBLE_VAULT_DECLARATION);
            this.vaultIdLabel = splat[3];
        }
    }

    private static boolean line2HasValidPrefix(String value) {
        return "          $ANSIBLE_VAULT".equals(value);
    }

    private static boolean line2HasValidLength(String[] parts) {
        return parts.length == 3 || parts.length == 4;
    }

    private static boolean isValidFormatVersion(String value) {
        return "1.1".equals(value) || "1.2".equals(value);
    }

    private void parseRemainingLines(List<String> lines) {
        List<String> remainingLines = KiwiLists.subListFrom(lines, 3);
        remainingLines.forEach(line -> {
            Preconditions.checkArgument((boolean)line.startsWith("          "), (Object)INVALID_SPACING_IN_ENCRYPTED_CONTENT);
            Preconditions.checkArgument((line.length() > 10 && line.charAt(10) != ' ' ? 1 : 0) != 0, (Object)INVALID_FORMAT_IN_ENCRYPTED_CONTENT);
        });
        this.encryptedContentLines = remainingLines;
    }

    private String buildEncryptedFileContent() {
        return this.encryptedFileFirstLine() + LINE_SEPARATOR + this.encryptedContentWithLeadingWhitespaceTrimmed();
    }

    private String encryptedFileFirstLine() {
        return "$ANSIBLE_VAULT;" + this.formatVersion + ";" + this.cipher + this.vaultIdLabelFragmentOrEmpty();
    }

    private String vaultIdLabelFragmentOrEmpty() {
        return Optional.ofNullable(this.vaultIdLabel).map(label -> ";" + label).orElse("");
    }

    private String encryptedContentWithLeadingWhitespaceTrimmed() {
        return this.encryptedContentLines.stream().map(String::stripLeading).collect(Collectors.joining(LINE_SEPARATOR));
    }

    byte[] getEncryptedFileBytes() {
        return this.encryptedFileContent.getBytes(StandardCharsets.UTF_8);
    }

    Path generateRandomFilePath(String tempDirectoryPath) {
        return VaultEncryptedVariable.generateRandomFilePath(tempDirectoryPath, this.variableName);
    }

    static Path generateRandomFilePath(String tempDirectoryPath, String variableName) {
        return Path.of(tempDirectoryPath, VaultEncryptedVariable.generateRandomFileName(variableName));
    }

    private static String generateRandomFileName(String variableName) {
        return variableName + "." + Integer.toUnsignedString(ThreadLocalRandom.current().nextInt()) + Long.toUnsignedString(ThreadLocalRandom.current().nextLong()) + ".txt";
    }

    Optional<String> getVaultIdLabel() {
        return Optional.ofNullable(this.vaultIdLabel);
    }

    @Generated
    String getVariableName() {
        return this.variableName;
    }

    @Generated
    String getFormatVersion() {
        return this.formatVersion;
    }

    @Generated
    String getCipher() {
        return this.cipher;
    }

    @Generated
    List<String> getEncryptedContentLines() {
        return this.encryptedContentLines;
    }

    @Generated
    String getEncryptedFileContent() {
        return this.encryptedFileContent;
    }
}

