/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.ansible.vault;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.ansible.vault.OsCommand;
import org.kiwiproject.ansible.vault.VaultConfiguration;
import org.kiwiproject.ansible.vault.VaultDecryptCommand;
import org.kiwiproject.ansible.vault.VaultEncryptCommand;
import org.kiwiproject.ansible.vault.VaultEncryptStringCommand;
import org.kiwiproject.ansible.vault.VaultEncryptedVariable;
import org.kiwiproject.ansible.vault.VaultEncryptionException;
import org.kiwiproject.ansible.vault.VaultRekeyCommand;
import org.kiwiproject.ansible.vault.VaultViewCommand;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.base.process.ProcessHelper;
import org.kiwiproject.io.KiwiIO;
import org.kiwiproject.logging.LazyLogParameterSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultEncryptionHelper {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(VaultEncryptionHelper.class);
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String ENCRYPTED_FILE_PATH_CANNOT_BE_NULL = "encryptedFilePath cannot be null";
    private static final int DEFAULT_TIMEOUT = 10;
    private static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private final ProcessHelper processHelper;
    private final VaultConfiguration configuration;

    public VaultEncryptionHelper(VaultConfiguration configuration) {
        this(configuration, new ProcessHelper());
    }

    @VisibleForTesting
    VaultEncryptionHelper(VaultConfiguration configuration, ProcessHelper processHelper) {
        KiwiPreconditions.checkArgumentNotNull(configuration, "configuration is required");
        KiwiPreconditions.checkArgumentNotNull(processHelper, "processHelper is required");
        this.configuration = VaultEncryptionHelper.validateAndCopyVaultConfiguration(configuration);
        this.processHelper = processHelper;
    }

    private static VaultConfiguration validateAndCopyVaultConfiguration(VaultConfiguration configuration) {
        KiwiPreconditions.checkArgumentNotBlank(configuration.getVaultPasswordFilePath(), "vaultPasswordFilePath is required");
        Preconditions.checkArgument((boolean)VaultEncryptionHelper.isExistingPath(configuration.getVaultPasswordFilePath()), (String)"vault password file does not exist: %s", (Object)configuration.getVaultPasswordFilePath());
        KiwiPreconditions.checkArgumentNotBlank(configuration.getAnsibleVaultPath(), "ansibleVaultPath is required");
        Preconditions.checkArgument((boolean)VaultEncryptionHelper.isExistingPath(configuration.getAnsibleVaultPath()), (String)"ansible-vault executable does not exist: %s", (Object)configuration.getAnsibleVaultPath());
        return configuration.copyOf();
    }

    public Path encryptFile(Path plainTextFilePath) {
        KiwiPreconditions.checkArgumentNotNull(plainTextFilePath, "plainTextFilePath cannot be null");
        return this.encryptFile(plainTextFilePath.toString());
    }

    public Path encryptFile(String plainTextFilePath) {
        VaultEncryptCommand osCommand = VaultEncryptCommand.from(this.configuration, plainTextFilePath);
        return this.executeVaultCommandWithoutOutput(osCommand, plainTextFilePath);
    }

    public Path encryptFile(Path plainTextFilePath, String vaultIdLabel) {
        KiwiPreconditions.checkArgumentNotNull(plainTextFilePath, "plainTextFilePath cannot be null");
        return this.encryptFile(plainTextFilePath.toString(), vaultIdLabel);
    }

    public Path encryptFile(String plainTextFilePath, String vaultIdLabel) {
        VaultEncryptCommand osCommand = VaultEncryptCommand.from(this.configuration, vaultIdLabel, plainTextFilePath);
        return this.executeVaultCommandWithoutOutput(osCommand, plainTextFilePath);
    }

    public Path decryptFile(Path encryptedFilePath) {
        KiwiPreconditions.checkArgumentNotNull(encryptedFilePath, ENCRYPTED_FILE_PATH_CANNOT_BE_NULL);
        return this.decryptFile(encryptedFilePath.toString());
    }

    public Path decryptFile(String encryptedFilePath) {
        VaultDecryptCommand osCommand = VaultDecryptCommand.from(this.configuration, encryptedFilePath);
        return this.executeVaultCommandWithoutOutput(osCommand, encryptedFilePath);
    }

    public Path decryptFile(Path encryptedFilePath, Path outputFilePath) {
        KiwiPreconditions.checkArgumentNotNull(encryptedFilePath, ENCRYPTED_FILE_PATH_CANNOT_BE_NULL);
        KiwiPreconditions.checkArgumentNotNull(outputFilePath, "outputFilePath cannot be null");
        return this.decryptFile(encryptedFilePath.toString(), outputFilePath.toString());
    }

    public Path decryptFile(String encryptedFilePath, String outputFilePath) {
        KiwiPreconditions.checkArgumentNotBlank(encryptedFilePath, "encryptedFilePath cannot be blank");
        KiwiPreconditions.checkArgumentNotBlank(outputFilePath, "outputFilePath cannot be blank");
        Preconditions.checkArgument((!outputFilePath.equalsIgnoreCase(encryptedFilePath) ? 1 : 0) != 0, (Object)"outputFilePath must be different than encryptedFilePath (case-insensitive)");
        VaultDecryptCommand osCommand = VaultDecryptCommand.from(this.configuration, encryptedFilePath, outputFilePath);
        this.executeVaultCommandWithoutOutput(osCommand, encryptedFilePath);
        return Path.of(outputFilePath, new String[0]);
    }

    public String viewFile(Path encryptedFilePath) {
        KiwiPreconditions.checkArgumentNotNull(encryptedFilePath, ENCRYPTED_FILE_PATH_CANNOT_BE_NULL);
        return this.viewFile(encryptedFilePath.toString());
    }

    public String viewFile(String encryptedFilePath) {
        VaultViewCommand osCommand = VaultViewCommand.from(this.configuration, encryptedFilePath);
        return this.executeVaultCommandReturningStdout(osCommand);
    }

    public Path rekeyFile(Path encryptedFilePath, Path newVaultPasswordFilePath) {
        KiwiPreconditions.checkArgumentNotNull(encryptedFilePath, ENCRYPTED_FILE_PATH_CANNOT_BE_NULL);
        KiwiPreconditions.checkArgumentNotNull(newVaultPasswordFilePath, "newVaultPasswordFilePath cannot be null");
        return this.rekeyFile(encryptedFilePath.toString(), newVaultPasswordFilePath.toString());
    }

    public Path rekeyFile(String encryptedFilePath, String newVaultPasswordFilePath) {
        KiwiPreconditions.checkArgumentNotBlank(encryptedFilePath, "encryptedFilePath cannot be blank");
        KiwiPreconditions.checkArgumentNotBlank(newVaultPasswordFilePath, "newVaultPasswordFilePath cannot be blank");
        Preconditions.checkArgument((!newVaultPasswordFilePath.equalsIgnoreCase(this.configuration.getVaultPasswordFilePath()) ? 1 : 0) != 0, (Object)"newVaultPasswordFilePath file must be different than configuration.vaultPasswordFilePath (case-insensitive)");
        VaultRekeyCommand osCommand = VaultRekeyCommand.from(this.configuration, encryptedFilePath, newVaultPasswordFilePath);
        return this.executeVaultCommandWithoutOutput(osCommand, encryptedFilePath);
    }

    private Path executeVaultCommandWithoutOutput(OsCommand osCommand, String filePath) {
        this.executeVaultCommand(osCommand);
        return Path.of(filePath, new String[0]);
    }

    public String encryptString(String plainText, String variableName) {
        VaultEncryptStringCommand osCommand = VaultEncryptStringCommand.from(this.configuration, plainText, variableName);
        return this.executeVaultCommandReturningStdout(osCommand);
    }

    public String encryptString(String vaultIdLabel, String plainText, String variableName) {
        VaultEncryptStringCommand osCommand = VaultEncryptStringCommand.from(this.configuration, vaultIdLabel, plainText, variableName);
        return this.executeVaultCommandReturningStdout(osCommand);
    }

    public String decryptString(String encryptedString) {
        KiwiPreconditions.checkArgumentNotBlank(this.configuration.getTempDirectory(), "configuration.tempDirectory is required for decryptString");
        VaultEncryptedVariable encryptedVariable = new VaultEncryptedVariable(encryptedString);
        Path tempFilePath = encryptedVariable.generateRandomFilePath(this.configuration.getTempDirectory());
        try {
            VaultEncryptionHelper.createTempDirectoryIfNecessary(Path.of(this.configuration.getTempDirectory(), new String[0]));
            this.writeEncryptStringContentToTempFile(encryptedVariable, tempFilePath);
            VaultDecryptCommand osCommand = VaultDecryptCommand.toStdoutFrom(this.configuration, tempFilePath.toString());
            String string = this.executeVaultCommandReturningStdout(osCommand);
            return string;
        }
        catch (Exception e) {
            LOG.error("Error decrypting", (Throwable)e);
            throw e;
        }
        finally {
            this.deleteFileQuietly(tempFilePath);
        }
    }

    private static boolean isExistingPath(String filePath) {
        return Files.exists(Path.of(filePath, new String[0]), new LinkOption[0]);
    }

    private static void createTempDirectoryIfNecessary(Path tempDirectoryPath) {
        try {
            Files.createDirectories(tempDirectoryPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            String message = KiwiStrings.format("Error creating temporary directory: {}", tempDirectoryPath);
            LOG.error(message);
            throw new UncheckedIOException(message, e);
        }
    }

    private void writeEncryptStringContentToTempFile(VaultEncryptedVariable encryptedVariable, Path tempFilePath) {
        try {
            LOG.trace("Payload to write ----{}{}{}----- End payload ----", new Object[]{LINE_SEPARATOR, encryptedVariable.getEncryptedFileContent(), LINE_SEPARATOR});
            Files.write(tempFilePath, encryptedVariable.getEncryptedFileBytes(), new OpenOption[0]);
            LOG.debug("Wrote temporary file containing encrypt_string content: {}", (Object)tempFilePath);
        }
        catch (IOException e) {
            LOG.error("Error writing temp file: {}", (Object)tempFilePath, (Object)e);
            throw new UncheckedIOException("Error copying to temp file", e);
        }
    }

    private void deleteFileQuietly(Path path) {
        try {
            LOG.debug("Delete path: {}", (Object)path);
            Files.delete(path);
        }
        catch (IOException e) {
            LOG.error("Could not delete path: {}", (Object)path, (Object)e);
        }
    }

    private String executeVaultCommandReturningStdout(OsCommand osCommand) {
        Process vaultProcess = this.executeVaultCommand(osCommand);
        return KiwiIO.readInputStreamOf(vaultProcess);
    }

    private Process executeVaultCommand(OsCommand osCommand) {
        LOG.debug("Ansible command: {}", LazyLogParameterSupplier.lazy(osCommand::getCommandParts));
        Process vaultProcess = this.processHelper.launch(osCommand.getCommandParts());
        Integer exitCode = this.processHelper.waitForExit(vaultProcess, 10L, DEFAULT_TIMEOUT_UNIT).orElseThrow(() -> new VaultEncryptionException("ansible-vault did not exit before timeout"));
        LOG.debug("ansible-vault exit code: {}", (Object)exitCode);
        if (exitCode != 0) {
            String rawErrorOutput = KiwiIO.readErrorStreamOf(vaultProcess);
            String errorOutput = StringUtils.isBlank((CharSequence)rawErrorOutput) ? "[no stderr]" : rawErrorOutput.trim();
            LOG.debug("Error output: [{}]", (Object)errorOutput);
            String message = KiwiStrings.f("ansible-vault returned non-zero exit code {}. Stderr: {}", exitCode, errorOutput);
            throw new VaultEncryptionException(message);
        }
        return vaultProcess;
    }
}

