/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.ansible.vault;

import java.beans.ConstructorProperties;
import java.nio.file.Paths;
import java.util.List;
import lombok.Generated;
import org.kiwiproject.ansible.vault.OsCommand;
import org.kiwiproject.ansible.vault.VaultConfiguration;
import org.kiwiproject.base.KiwiPreconditions;

public class VaultViewCommand
implements OsCommand {
    private final String ansibleVaultPath;
    private final String vaultPasswordFilePath;
    private final String encryptedFilePath;

    public static VaultViewCommand from(VaultConfiguration configuration, String encryptedFilePath) {
        KiwiPreconditions.checkArgumentNotNull(configuration, "configuration cannot be null");
        KiwiPreconditions.checkArgumentNotBlank(encryptedFilePath, "encryptedFilePath cannot be blank");
        return VaultViewCommand.builder().ansibleVaultPath(configuration.getAnsibleVaultPath()).vaultPasswordFilePath(configuration.getVaultPasswordFilePath()).encryptedFilePath(encryptedFilePath).build();
    }

    @Override
    public List<String> getCommandParts() {
        return List.of(this.ansibleVaultPath, "view", "--vault-password-file", this.vaultPasswordFilePath, Paths.get(this.encryptedFilePath, new String[0]).toString());
    }

    @ConstructorProperties(value={"ansibleVaultPath", "vaultPasswordFilePath", "encryptedFilePath"})
    @Generated
    VaultViewCommand(String ansibleVaultPath, String vaultPasswordFilePath, String encryptedFilePath) {
        this.ansibleVaultPath = ansibleVaultPath;
        this.vaultPasswordFilePath = vaultPasswordFilePath;
        this.encryptedFilePath = encryptedFilePath;
    }

    @Generated
    public static VaultViewCommandBuilder builder() {
        return new VaultViewCommandBuilder();
    }

    @Generated
    public static class VaultViewCommandBuilder {
        @Generated
        private String ansibleVaultPath;
        @Generated
        private String vaultPasswordFilePath;
        @Generated
        private String encryptedFilePath;

        @Generated
        VaultViewCommandBuilder() {
        }

        @Generated
        public VaultViewCommandBuilder ansibleVaultPath(String ansibleVaultPath) {
            this.ansibleVaultPath = ansibleVaultPath;
            return this;
        }

        @Generated
        public VaultViewCommandBuilder vaultPasswordFilePath(String vaultPasswordFilePath) {
            this.vaultPasswordFilePath = vaultPasswordFilePath;
            return this;
        }

        @Generated
        public VaultViewCommandBuilder encryptedFilePath(String encryptedFilePath) {
            this.encryptedFilePath = encryptedFilePath;
            return this;
        }

        @Generated
        public VaultViewCommand build() {
            return new VaultViewCommand(this.ansibleVaultPath, this.vaultPasswordFilePath, this.encryptedFilePath);
        }

        @Generated
        public String toString() {
            return "VaultViewCommand.VaultViewCommandBuilder(ansibleVaultPath=" + this.ansibleVaultPath + ", vaultPasswordFilePath=" + this.vaultPasswordFilePath + ", encryptedFilePath=" + this.encryptedFilePath + ")";
        }
    }
}

