/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.kiwiproject.base.KiwiDeprecated;

public interface KiwiEnvironment {
    public Date currentDate();

    public Time currentTime();

    public Timestamp currentTimestamp();

    public Instant currentInstant();

    public Instant currentInstant(ZoneId var1);

    public LocalDate currentLocalDate();

    public LocalDate currentLocalDate(ZoneId var1);

    public LocalTime currentLocalTime();

    public LocalTime currentLocalTime(ZoneId var1);

    public LocalDateTime currentLocalDateTime();

    public LocalDateTime currentLocalDateTime(ZoneId var1);

    public ZonedDateTime currentZonedDateTimeUTC();

    public ZonedDateTime currentZonedDateTime(ZoneId var1);

    public ZonedDateTime currentZonedDateTime();

    public long currentTimeMillis();

    public long nanoTime();

    public long currentPid();

    public OptionalLong tryGetCurrentPid();

    @Deprecated(since="1.1.0", forRemoval=true)
    @KiwiDeprecated(since="1.1.0", removeAt="2.0.0", replacedBy={"currentPid()"}, reference={"https://github.com/kiwiproject/kiwi/issues/642"})
    public String currentProcessId();

    @Deprecated(since="1.1.0", forRemoval=true)
    @KiwiDeprecated(since="1.1.0", removeAt="2.0.0", replacedBy={"tryGetCurrentPid()"}, reference={"https://github.com/kiwiproject/kiwi/issues/642"})
    public Optional<Integer> tryGetCurrentProcessId();

    public void sleep(long var1) throws InterruptedException;

    public void sleep(long var1, TimeUnit var3) throws InterruptedException;

    public void sleep(long var1, int var3) throws InterruptedException;

    public boolean sleepQuietly(long var1);

    public boolean sleepQuietly(long var1, TimeUnit var3);

    public boolean sleepQuietly(long var1, int var3);

    public String getenv(String var1);

    public Map<String, String> getenv();

    public Properties getProperties();

    public String getProperty(String var1);

    public String getProperty(String var1, String var2);
}

