/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class KiwiStrings {
    public static final char SPACE = ' ';
    public static final char TAB = '\t';
    public static final char COMMA = ',';
    public static final char NEWLINE = '\n';
    private static final Splitter TRIMMING_AND_EMPTY_OMITTING_SPACE_SPLITTER = Splitter.on((char)' ').omitEmptyStrings().trimResults();
    private static final Splitter TRIMMING_AND_EMPTY_OMITTING_TAB_SPLITTER = Splitter.on((char)'\t').omitEmptyStrings().trimResults();
    private static final Splitter TRIMMING_AND_EMPTY_OMITTING_COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private static final Splitter TRIMMING_AND_EMPTY_OMITTING_NEWLINE_SPLITTER = Splitter.on((char)'\n').omitEmptyStrings().trimResults();

    public static Iterable<String> splitWithTrimAndOmitEmpty(CharSequence sequence) {
        return KiwiStrings.splitWithTrimAndOmitEmpty(sequence, ' ');
    }

    public static Iterable<String> splitWithTrimAndOmitEmpty(CharSequence sequence, char separator) {
        switch (separator) {
            case ',': {
                return TRIMMING_AND_EMPTY_OMITTING_COMMA_SPLITTER.split(sequence);
            }
            case ' ': {
                return TRIMMING_AND_EMPTY_OMITTING_SPACE_SPLITTER.split(sequence);
            }
            case '\t': {
                return TRIMMING_AND_EMPTY_OMITTING_TAB_SPLITTER.split(sequence);
            }
            case '\n': {
                return TRIMMING_AND_EMPTY_OMITTING_NEWLINE_SPLITTER.split(sequence);
            }
        }
        return Splitter.on((char)separator).omitEmptyStrings().trimResults().split(sequence);
    }

    public static Iterable<String> splitWithTrimAndOmitEmpty(CharSequence sequence, String separator) {
        return Splitter.on((String)separator).omitEmptyStrings().trimResults().split(sequence);
    }

    public static List<String> splitToList(CharSequence sequence) {
        return KiwiStrings.splitToList(sequence, ' ');
    }

    public static List<String> splitToList(CharSequence sequence, char separator) {
        switch (separator) {
            case ',': {
                return TRIMMING_AND_EMPTY_OMITTING_COMMA_SPLITTER.splitToList(sequence);
            }
            case ' ': {
                return TRIMMING_AND_EMPTY_OMITTING_SPACE_SPLITTER.splitToList(sequence);
            }
            case '\t': {
                return TRIMMING_AND_EMPTY_OMITTING_TAB_SPLITTER.splitToList(sequence);
            }
            case '\n': {
                return TRIMMING_AND_EMPTY_OMITTING_NEWLINE_SPLITTER.splitToList(sequence);
            }
        }
        return Splitter.on((char)separator).omitEmptyStrings().trimResults().splitToList(sequence);
    }

    public static List<String> splitToList(CharSequence sequence, char separator, int maxGroups) {
        return Splitter.on((char)separator).limit(maxGroups).omitEmptyStrings().trimResults().splitToList(sequence);
    }

    public static List<String> splitToList(CharSequence sequence, String separator) {
        return Splitter.on((String)separator).omitEmptyStrings().trimResults().splitToList(sequence);
    }

    public static List<String> splitToList(CharSequence sequence, String separator, int maxGroups) {
        return Splitter.on((String)separator).limit(maxGroups).omitEmptyStrings().trimResults().splitToList(sequence);
    }

    public static List<String> splitOnCommas(CharSequence sequence) {
        return ImmutableList.copyOf(KiwiStrings.splitWithTrimAndOmitEmpty(sequence, ','));
    }

    public static List<String> nullSafeSplitOnCommas(CharSequence sequence) {
        if (StringUtils.isBlank((CharSequence)sequence)) {
            return List.of();
        }
        return KiwiStrings.splitOnCommas(sequence);
    }

    public static String blankToNull(String sequence) {
        return StringUtils.isBlank((CharSequence)sequence) ? null : sequence;
    }

    public static String format(String template, Object ... args) {
        String nonNullTemplate = String.valueOf(template);
        if (nonNullTemplate.contains("%s")) {
            return KiwiStrings.formatGuavaStyle(template, args);
        }
        return KiwiStrings.formatSlf4jJStyle(nonNullTemplate, args);
    }

    public static String f(String template, Object ... args) {
        return KiwiStrings.format(template, args);
    }

    public static String formatGuavaStyle(String template, Object ... args) {
        return KiwiStrings.formatInternal(template, "%s", args);
    }

    public static String formatSlf4jJStyle(String template, Object ... args) {
        return KiwiStrings.formatInternal(template, "{}", args);
    }

    private static String formatInternal(String template, String placeholder, Object ... args) {
        int placeholderStart;
        String nonNullTemplate = String.valueOf(template);
        StringBuilder builder = new StringBuilder(nonNullTemplate.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = nonNullTemplate.indexOf(placeholder, templateStart)) != -1) {
            builder.append(nonNullTemplate, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(nonNullTemplate, templateStart, nonNullTemplate.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    @Generated
    private KiwiStrings() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

