/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jaxrs;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.jaxrs.KiwiJaxrsValidations;
import org.kiwiproject.jaxrs.exception.JaxrsBadRequestException;
import org.kiwiproject.jaxrs.exception.JaxrsNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiResources {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(KiwiResources.class);
    private static final Map<String, Object> EMPTY_HEADERS = Map.of();

    public static <T> void verifyExistence(T resourceEntity) {
        KiwiResources.verifyExistence(resourceEntity, null);
    }

    public static <T> T verifyExistence(Optional<T> resourceEntity) {
        KiwiResources.verifyExistence(resourceEntity.orElse(null), null);
        return resourceEntity.orElseThrow();
    }

    public static <T> void verifyExistence(T resourceEntity, Class<T> entityType, Object identifier) {
        String notFoundMessage = JaxrsNotFoundException.buildMessage(entityType.getSimpleName(), identifier);
        KiwiResources.verifyExistence(resourceEntity, notFoundMessage);
    }

    public static <T> T verifyExistence(Optional<T> resourceEntity, Class<T> entityType, Object identifier) {
        String notFoundMessage = JaxrsNotFoundException.buildMessage(entityType.getSimpleName(), identifier);
        KiwiResources.verifyExistence(resourceEntity.orElse(null), notFoundMessage);
        return resourceEntity.orElseThrow();
    }

    public static <T> void verifyExistence(T resourceEntity, String notFoundMessage) {
        if (Objects.isNull(resourceEntity)) {
            throw new JaxrsNotFoundException(notFoundMessage);
        }
    }

    public static <T> T verifyExistence(Optional<T> resourceEntity, String notFoundMessage) {
        KiwiResources.verifyExistence(resourceEntity.orElse(null), notFoundMessage);
        return resourceEntity.orElseThrow();
    }

    public static Response newResponse(Response.Status status, Object entity) {
        return KiwiResources.newResponseBuilder(status, entity).build();
    }

    public static Response.ResponseBuilder newResponseBuilder(Response.Status status, Object entity) {
        return KiwiResources.newResponseBuilder(status, entity, EMPTY_HEADERS);
    }

    public static Response newResponse(Response.Status status, Object entity, String contentType) {
        return KiwiResources.newResponseBuilder(status, entity, contentType).build();
    }

    public static Response.ResponseBuilder newResponseBuilder(Response.Status status, Object entity, String contentType) {
        return KiwiResources.newResponseBuilder(status, entity).type(contentType);
    }

    public static Response newResponse(Response.Status status, Object entity, Map<String, Object> singleValuedHeaders) {
        return KiwiResources.newResponseBuilder(status, entity, singleValuedHeaders).build();
    }

    public static Response.ResponseBuilder newResponseBuilder(Response.Status status, Object entity, Map<String, Object> singleValuedHeaders) {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)status).entity(entity);
        singleValuedHeaders.forEach((arg_0, arg_1) -> ((Response.ResponseBuilder)responseBuilder).header(arg_0, arg_1));
        return responseBuilder;
    }

    public static Response newResponse(Response.Status status, Object entity, MultivaluedMap<String, Object> headers) {
        return KiwiResources.newResponseBuilder(status, entity, headers).build();
    }

    public static Response.ResponseBuilder newResponseBuilder(Response.Status status, Object entity, MultivaluedMap<String, Object> headers) {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)status).entity(entity);
        headers.forEach((name, values) -> values.forEach(value -> responseBuilder.header(name, value)));
        return responseBuilder;
    }

    public static Response createdResponse(URI location, Object entity) {
        return KiwiResources.createdResponseBuilder(location, entity).build();
    }

    public static Response.ResponseBuilder createdResponseBuilder(URI location, Object entity) {
        return Response.created((URI)location).entity(entity);
    }

    public static Response okResponse(Object entity) {
        return KiwiResources.okResponseBuilder(entity).build();
    }

    public static Response.ResponseBuilder okResponseBuilder(Object entity) {
        return Response.ok((Object)entity);
    }

    public static Response newResponseBufferingEntityFrom(Response originalResponse) {
        return KiwiResources.newResponseBuilderBufferingEntityFrom(originalResponse).build();
    }

    public static Response.ResponseBuilder newResponseBuilderBufferingEntityFrom(Response originalResponse) {
        boolean wasBuffered = originalResponse.bufferEntity();
        if (!wasBuffered) {
            LOG.warn("Attempt to buffer entity in original response returned false; possible causes: it was not backed by an unconsumed input stream; the input stream was already consumed; or, it did not have an entity");
        }
        return Response.fromResponse((Response)originalResponse);
    }

    public static int validateIntParameter(Map<String, Object> parameters, String parameterName) {
        KiwiJaxrsValidations.assertNotNull(parameterName, parameters);
        Object value = parameters.get(parameterName);
        KiwiJaxrsValidations.assertNotNull(parameterName, value);
        Optional<Integer> result = Optional.ofNullable(Ints.tryParse((String)value.toString()));
        return result.orElseThrow(() -> new JaxrsBadRequestException(KiwiStrings.f("{} must be an integer", value), parameterName));
    }

    public static long validateLongParameter(Map<String, Object> parameters, String parameterName) {
        KiwiJaxrsValidations.assertNotNull(parameterName, parameters);
        Object value = parameters.get(parameterName);
        KiwiJaxrsValidations.assertNotNull(parameterName, value);
        Optional<Long> result = Optional.ofNullable(Longs.tryParse((String)value.toString()));
        return result.orElseThrow(() -> new JaxrsBadRequestException(KiwiStrings.f("{} must be a long", value), parameterName));
    }

    @Generated
    private KiwiResources() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

