/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jaxrs.client;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiArrays;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.collect.KiwiMaps;

@Beta
public class WebTargetHelper {
    private final WebTarget webTarget;

    WebTargetHelper(WebTarget webTarget) {
        this.webTarget = KiwiPreconditions.requireNotNull(webTarget, "webTarget must not be null", new Object[0]);
    }

    @VisibleForTesting
    WebTarget wrapped() {
        return this.webTarget;
    }

    public WebTarget toWebTarget() {
        return this.webTarget.path("");
    }

    public static WebTargetHelper withWebTarget(WebTarget webTarget) {
        return new WebTargetHelper(webTarget);
    }

    public WebTargetHelper queryParamRequireNotNull(String name, Object value) {
        KiwiPreconditions.checkArgumentNotBlank(name, "name cannot be blank");
        KiwiPreconditions.checkArgumentNotNull(value, "value cannot be null for parameter %s", name);
        WebTarget newWebTarget = this.webTarget.queryParam(name, new Object[]{value});
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper queryParamIfNotNull(String name, Object value) {
        if (StringUtils.isBlank((CharSequence)name) || Objects.isNull(value)) {
            return this;
        }
        WebTarget newWebTarget = this.webTarget.queryParam(name, new Object[]{value});
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper queryParamFilterNotNull(String name, Object ... values) {
        if (StringUtils.isBlank((CharSequence)name) || KiwiArrays.isNullOrEmpty(values)) {
            return this;
        }
        return this.queryParamFilterNotNull(name, Arrays.stream(values));
    }

    public WebTargetHelper queryParamFilterNotNull(String name, List<Object> values) {
        if (StringUtils.isBlank((CharSequence)name) || KiwiLists.isNullOrEmpty(values)) {
            return this;
        }
        return this.queryParamFilterNotNull(name, values.stream());
    }

    public WebTargetHelper queryParamFilterNotNull(String name, Stream<Object> stream) {
        if (StringUtils.isBlank((CharSequence)name) || Objects.isNull(stream)) {
            return this;
        }
        Object[] nonNullValues = stream.filter(Objects::nonNull).toArray();
        WebTarget newWebTarget = this.webTarget.queryParam(name, nonNullValues);
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper queryParamRequireNotBlank(String name, String value) {
        KiwiPreconditions.checkArgumentNotBlank(name, "name cannot be blank");
        KiwiPreconditions.checkArgumentNotBlank(value, "value cannot be blank for parameter %s", name);
        WebTarget newWebTarget = this.webTarget.queryParam(name, new Object[]{value});
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper queryParamIfNotBlank(String name, String value) {
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)value)) {
            return this;
        }
        WebTarget newWebTarget = this.webTarget.queryParam(name, new Object[]{value});
        return new WebTargetHelper(newWebTarget);
    }

    public WebTargetHelper queryParamFilterNotBlank(String name, String ... values) {
        if (StringUtils.isBlank((CharSequence)name) || KiwiArrays.isNullOrEmpty(values)) {
            return this;
        }
        return this.queryParamFilterNotBlank(name, Arrays.stream(values));
    }

    public WebTargetHelper queryParamFilterNotBlank(String name, List<String> values) {
        if (StringUtils.isBlank((CharSequence)name) || KiwiLists.isNullOrEmpty(values)) {
            return this;
        }
        return this.queryParamFilterNotBlank(name, values.stream());
    }

    public WebTargetHelper queryParamFilterNotBlank(String name, Stream<String> stream) {
        if (StringUtils.isBlank((CharSequence)name) || Objects.isNull(stream)) {
            return this;
        }
        Object[] nonBlankValues = stream.filter(StringUtils::isNotBlank).toArray();
        WebTarget newWebTarget = this.webTarget.queryParam(name, nonBlankValues);
        return new WebTargetHelper(newWebTarget);
    }

    public <V> WebTargetHelper queryParamsFromMap(Map<String, V> parameters) {
        if (KiwiMaps.isNullOrEmpty(parameters)) {
            return this;
        }
        WebTargetHelper targetHelper = this;
        for (Map.Entry<String, V> entry : parameters.entrySet()) {
            targetHelper = targetHelper.queryParamIfNotNull(entry.getKey(), entry.getValue());
        }
        return targetHelper;
    }

    public <V> WebTargetHelper queryParamsFromMultivaluedMap(MultivaluedMap<String, V> parameters) {
        if (Objects.isNull(parameters) || parameters.isEmpty()) {
            return this;
        }
        WebTargetHelper targetHelper = this;
        for (Map.Entry entry : parameters.entrySet()) {
            targetHelper = targetHelper.queryParamFilterNotNull((String)entry.getKey(), (List)entry.getValue());
        }
        return targetHelper;
    }

    @Generated
    public URI getUri() {
        return this.webTarget.getUri();
    }

    @Generated
    public UriBuilder getUriBuilder() {
        return this.webTarget.getUriBuilder();
    }

    @Generated
    public WebTarget path(String arg0) {
        return this.webTarget.path(arg0);
    }

    @Generated
    public WebTarget resolveTemplate(String arg0, Object arg1) {
        return this.webTarget.resolveTemplate(arg0, arg1);
    }

    @Generated
    public WebTarget resolveTemplate(String arg0, Object arg1, boolean arg2) {
        return this.webTarget.resolveTemplate(arg0, arg1, arg2);
    }

    @Generated
    public WebTarget resolveTemplateFromEncoded(String arg0, Object arg1) {
        return this.webTarget.resolveTemplateFromEncoded(arg0, arg1);
    }

    @Generated
    public WebTarget resolveTemplates(Map<String, Object> arg0) {
        return this.webTarget.resolveTemplates(arg0);
    }

    @Generated
    public WebTarget resolveTemplates(Map<String, Object> arg0, boolean arg1) {
        return this.webTarget.resolveTemplates(arg0, arg1);
    }

    @Generated
    public WebTarget resolveTemplatesFromEncoded(Map<String, Object> arg0) {
        return this.webTarget.resolveTemplatesFromEncoded(arg0);
    }

    @Generated
    public WebTarget matrixParam(String arg0, Object ... arg1) {
        return this.webTarget.matrixParam(arg0, arg1);
    }

    @Generated
    public WebTarget queryParam(String arg0, Object ... arg1) {
        return this.webTarget.queryParam(arg0, arg1);
    }

    @Generated
    public Invocation.Builder request() {
        return this.webTarget.request();
    }

    @Generated
    public Invocation.Builder request(String ... arg0) {
        return this.webTarget.request(arg0);
    }

    @Generated
    public Invocation.Builder request(MediaType ... arg0) {
        return this.webTarget.request(arg0);
    }

    @Generated
    public Configuration getConfiguration() {
        return this.webTarget.getConfiguration();
    }

    @Generated
    public WebTarget property(String arg0, Object arg1) {
        return (WebTarget)this.webTarget.property(arg0, arg1);
    }

    @Generated
    public WebTarget register(Class<?> arg0) {
        return (WebTarget)this.webTarget.register(arg0);
    }

    @Generated
    public WebTarget register(Class<?> arg0, int arg1) {
        return (WebTarget)this.webTarget.register(arg0, arg1);
    }

    @Generated
    public WebTarget register(Class<?> arg0, Class<?> ... arg1) {
        return (WebTarget)this.webTarget.register(arg0, (Class[])arg1);
    }

    @Generated
    public WebTarget register(Class<?> arg0, Map<Class<?>, Integer> arg1) {
        return (WebTarget)this.webTarget.register(arg0, arg1);
    }

    @Generated
    public WebTarget register(Object arg0) {
        return (WebTarget)this.webTarget.register(arg0);
    }

    @Generated
    public WebTarget register(Object arg0, int arg1) {
        return (WebTarget)this.webTarget.register(arg0, arg1);
    }

    @Generated
    public WebTarget register(Object arg0, Class<?> ... arg1) {
        return (WebTarget)this.webTarget.register(arg0, (Class[])arg1);
    }

    @Generated
    public WebTarget register(Object arg0, Map<Class<?>, Integer> arg1) {
        return (WebTarget)this.webTarget.register(arg0, arg1);
    }
}

