/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.spring.data;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiArrays;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.search.KiwiSearching;
import org.kiwiproject.spring.data.PagingParams;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public final class KiwiPaging {
    public static Pageable createPageable(PagingParams pagedRequest) {
        KiwiPreconditions.checkArgumentNotNull(pagedRequest, "pagedRequest cannot be null");
        KiwiPreconditions.checkArgumentNotNull(pagedRequest.getPage(), "page cannot be null");
        KiwiPreconditions.checkArgumentNotNull(pagedRequest.getLimit(), "limit cannot be null");
        return KiwiPaging.createPageable(pagedRequest.getPage(), pagedRequest.getLimit(), pagedRequest.getPrimaryDirection(), pagedRequest.getPrimarySort(), pagedRequest.getSecondaryDirection(), pagedRequest.getSecondarySort());
    }

    public static Pageable createPageable(int pageNumber, int sizePerPage, Object ... sortDirectionAndFieldNamePairs) {
        KiwiPreconditions.checkPositiveOrZero(pageNumber, "pageNumber cannot be negative");
        KiwiSearching.checkPageSize(sizePerPage);
        Sort sort = KiwiPaging.constructSortChainFromPairs(sortDirectionAndFieldNamePairs);
        if (Objects.nonNull(sort)) {
            return PageRequest.of((int)pageNumber, (int)sizePerPage, (Sort)sort);
        }
        return PageRequest.of((int)pageNumber, (int)sizePerPage);
    }

    public static Sort constructSortChainFromPairs(Object ... directionAndFieldPairs) {
        List<Sort> sortList = KiwiPaging.constructSortListFromPairs(directionAndFieldPairs);
        return KiwiPaging.constructSortChain(sortList);
    }

    public static List<Sort> constructSortListFromPairs(Object ... directionAndFieldPairs) {
        KiwiPreconditions.checkEvenItemCount(directionAndFieldPairs);
        List directionFieldPairs = Lists.partition((List)Lists.newArrayList((Object[])directionAndFieldPairs), (int)2);
        return directionFieldPairs.stream().filter(KiwiPaging::containsDirectionAndProperty).map(KiwiPaging::sortFromDirectionAndProperty).collect(Collectors.toList());
    }

    private static boolean containsDirectionAndProperty(List<Object> directionFieldPair) {
        return KiwiLists.first(directionFieldPair) instanceof Sort.Direction && KiwiLists.second(directionFieldPair) instanceof String;
    }

    private static Sort sortFromDirectionAndProperty(List<Object> directionFieldPair) {
        Sort.Direction direction = (Sort.Direction)KiwiLists.first(directionFieldPair);
        String property = (String)KiwiLists.second(directionFieldPair);
        return Sort.by((Sort.Direction)direction, (String[])new String[]{property});
    }

    public static Sort constructSortChain(Sort ... sorts) {
        if (KiwiArrays.isNullOrEmpty(sorts)) {
            return null;
        }
        return KiwiPaging.constructSortChain(Lists.newArrayList((Object[])sorts));
    }

    public static Sort constructSortChain(List<Sort> sorts) {
        if (KiwiLists.isNullOrEmpty(sorts)) {
            return null;
        }
        List filteredSorts = sorts.stream().filter(Objects::nonNull).collect(Collectors.toList());
        Sort firstSort = (Sort)KiwiLists.first(filteredSorts);
        List restOfSorts = KiwiLists.subListExcludingFirst(filteredSorts);
        return restOfSorts.stream().reduce(firstSort, Sort::and);
    }

    @Generated
    private KiwiPaging() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

