/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.json.JsonHelper;

final class InternalKiwiValidators {
    private static final JsonHelper JSON_HELPER = JsonHelper.newDropwizardJsonHelper();
    static final String TEMPLATE_REQUIRED = "{org.kiwiproject.validation.Required.message}";

    static <T> Comparable<T> toComparableOrNull(String compareValue, Comparable<T> value) {
        Comparable<Double> typedValue;
        if (StringUtils.isBlank((CharSequence)compareValue) || Objects.isNull(value)) {
            return null;
        }
        if (value instanceof Double) {
            typedValue = Double.valueOf(compareValue);
        } else if (value instanceof Float) {
            typedValue = Float.valueOf(compareValue);
        } else if (value instanceof Byte) {
            typedValue = Byte.valueOf(compareValue);
        } else if (value instanceof Short) {
            typedValue = Short.valueOf(compareValue);
        } else if (value instanceof Integer) {
            typedValue = Integer.valueOf(compareValue);
        } else if (value instanceof Long) {
            typedValue = Long.valueOf(compareValue);
        } else if (value instanceof BigDecimal) {
            typedValue = new BigDecimal(compareValue);
        } else if (value instanceof BigInteger) {
            typedValue = new BigInteger(compareValue);
        } else if (value instanceof Date) {
            typedValue = new Date(Long.parseLong(compareValue));
        } else if (value instanceof Instant) {
            typedValue = Instant.ofEpochMilli(Long.parseLong(compareValue));
        } else if (compareValue.stripLeading().startsWith("{")) {
            typedValue = (Comparable)JSON_HELPER.toObject(compareValue, value.getClass());
        } else {
            String message = "This validator does not support validating objects of type: " + value.getClass().getName();
            throw new IllegalArgumentException(message);
        }
        return typedValue;
    }

    @Generated
    private InternalKiwiValidators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

