/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.validation;

import java.util.Objects;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.kiwiproject.validation.Ipv4AndPort;

public class Ipv4AndPortValidator
implements ConstraintValidator<Ipv4AndPort, String> {
    private static final String IPV4_AND_PORT_REGEX = "^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3}):\\d+$";
    private static final Pattern IPV4_AND_PORT_PATTERN = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3}):\\d+$");
    private Ipv4AndPort ipv4AndPort;

    public void initialize(Ipv4AndPort constraintAnnotation) {
        this.ipv4AndPort = constraintAnnotation;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (Objects.isNull(value)) {
            return this.ipv4AndPort.allowNull();
        }
        return IPV4_AND_PORT_PATTERN.matcher(value).matches();
    }
}

