/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface CatchingRunnable
extends Runnable {
    @Override
    default public void run() {
        try {
            this.runSafely();
        }
        catch (Exception e) {
            CatchingRunnable.getLogger().error("Error occurred calling runSafely", (Throwable)e);
            try {
                this.handleExceptionSafely(e);
            }
            catch (Exception ex) {
                CatchingRunnable.getLogger().error("Error occurred calling handleExceptionSafely", (Throwable)ex);
            }
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(CatchingRunnable.class);
    }

    default public void handleExceptionSafely(Exception exception) {
    }

    public void runSafely();
}

