/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.config;

import io.dropwizard.client.ssl.TlsConfiguration;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.config.SSLContextConfiguration;
import org.kiwiproject.security.KeyAndTrustStoreConfigProvider;
import org.kiwiproject.security.KeyStoreType;
import org.kiwiproject.security.SSLContextProtocol;

public class TlsContextConfiguration
implements KeyAndTrustStoreConfigProvider {
    @NotBlank
    private String protocol;
    private String provider;
    private String keyStorePath;
    private String keyStorePassword;
    @NotBlank
    private String keyStoreType;
    private String keyStoreProvider;
    @NotBlank
    private String trustStorePath;
    @NotNull
    private String trustStorePassword;
    @NotBlank
    private String trustStoreType;
    private String trustStoreProvider;
    private boolean trustSelfSignedCertificates;
    private boolean verifyHostname;
    private boolean disableSniHostCheck;
    private List<String> supportedProtocols;
    private List<String> supportedCiphers;
    private String certAlias;

    public static TlsContextConfiguration fromDropwizardTlsConfiguration(TlsConfiguration tlsConfig) {
        KiwiPreconditions.checkArgumentNotNull(tlsConfig, "TlsConfiguration cannot be null");
        return TlsContextConfiguration.builder().protocol(tlsConfig.getProtocol()).provider(tlsConfig.getProvider()).keyStorePath(TlsContextConfiguration.absolutePathOrNull(tlsConfig.getKeyStorePath())).keyStorePassword(tlsConfig.getKeyStorePassword()).keyStoreType(tlsConfig.getKeyStoreType()).keyStoreProvider(tlsConfig.getKeyStoreProvider()).trustStorePath(TlsContextConfiguration.absolutePathOrNull(tlsConfig.getTrustStorePath())).trustStorePassword(tlsConfig.getTrustStorePassword()).trustStoreType(tlsConfig.getTrustStoreType()).trustStoreProvider(tlsConfig.getTrustStoreProvider()).trustSelfSignedCertificates(tlsConfig.isTrustSelfSignedCertificates()).verifyHostname(tlsConfig.isVerifyHostname()).disableSniHostCheck(false).supportedProtocols(tlsConfig.getSupportedProtocols()).supportedCiphers(tlsConfig.getSupportedCiphers()).certAlias(tlsConfig.getCertAlias()).build();
    }

    private static String absolutePathOrNull(@Nullable File nullableFile) {
        return Optional.ofNullable(nullableFile).map(File::getAbsolutePath).orElse(null);
    }

    public TlsConfiguration toDropwizardTlsConfiguration() {
        TlsConfiguration tlsConfig = new TlsConfiguration();
        tlsConfig.setProtocol(this.protocol);
        tlsConfig.setProvider(this.provider);
        File keyStoreFile = Optional.ofNullable(this.keyStorePath).map(File::new).orElse(null);
        tlsConfig.setKeyStorePath(keyStoreFile);
        tlsConfig.setKeyStorePassword(this.keyStorePassword);
        tlsConfig.setKeyStoreType(this.keyStoreType);
        tlsConfig.setKeyStoreProvider(this.keyStoreProvider);
        tlsConfig.setTrustStorePath(new File(this.trustStorePath));
        tlsConfig.setTrustStorePassword(this.trustStorePassword);
        tlsConfig.setTrustStoreType(this.trustStoreType);
        tlsConfig.setTrustStoreProvider(this.trustStoreProvider);
        tlsConfig.setTrustSelfSignedCertificates(this.trustSelfSignedCertificates);
        tlsConfig.setVerifyHostname(this.verifyHostname);
        tlsConfig.setSupportedProtocols(this.supportedProtocols);
        tlsConfig.setSupportedCiphers(this.supportedCiphers);
        tlsConfig.setCertAlias(this.certAlias);
        return tlsConfig;
    }

    public SSLContextConfiguration toSslContextConfiguration() {
        return SSLContextConfiguration.builder().keyStorePath(this.keyStorePath).keyStorePassword(this.keyStorePassword).keyStoreType(this.keyStoreType).trustStorePath(this.trustStorePath).trustStorePassword(this.trustStorePassword).trustStoreType(this.trustStoreType).protocol(this.protocol).verifyHostname(this.verifyHostname).disableSniHostCheck(this.disableSniHostCheck).build();
    }

    @Generated
    private static String $default$protocol() {
        return SSLContextProtocol.TLS_1_2.value;
    }

    @Generated
    private static String $default$keyStoreType() {
        return KeyStoreType.JKS.value;
    }

    @Generated
    private static String $default$trustStoreType() {
        return KeyStoreType.JKS.value;
    }

    @Generated
    private static boolean $default$verifyHostname() {
        return true;
    }

    @Generated
    public static TlsContextConfigurationBuilder builder() {
        return new TlsContextConfigurationBuilder();
    }

    @Override
    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public String getProvider() {
        return this.provider;
    }

    @Override
    @Generated
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Override
    @Generated
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Override
    @Generated
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Generated
    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    @Override
    @Generated
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Override
    @Generated
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Override
    @Generated
    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @Generated
    public String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    @Generated
    public boolean isTrustSelfSignedCertificates() {
        return this.trustSelfSignedCertificates;
    }

    @Override
    @Generated
    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    @Generated
    public boolean isDisableSniHostCheck() {
        return this.disableSniHostCheck;
    }

    @Generated
    public List<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    @Generated
    public List<String> getSupportedCiphers() {
        return this.supportedCiphers;
    }

    @Generated
    public String getCertAlias() {
        return this.certAlias;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Generated
    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    @Generated
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @Generated
    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    @Generated
    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    @Generated
    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    @Generated
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @Generated
    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    @Generated
    public void setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    @Generated
    public void setTrustSelfSignedCertificates(boolean trustSelfSignedCertificates) {
        this.trustSelfSignedCertificates = trustSelfSignedCertificates;
    }

    @Generated
    public void setVerifyHostname(boolean verifyHostname) {
        this.verifyHostname = verifyHostname;
    }

    @Generated
    public void setDisableSniHostCheck(boolean disableSniHostCheck) {
        this.disableSniHostCheck = disableSniHostCheck;
    }

    @Generated
    public void setSupportedProtocols(List<String> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    @Generated
    public void setSupportedCiphers(List<String> supportedCiphers) {
        this.supportedCiphers = supportedCiphers;
    }

    @Generated
    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    @Generated
    public TlsContextConfiguration() {
        this.protocol = TlsContextConfiguration.$default$protocol();
        this.keyStoreType = TlsContextConfiguration.$default$keyStoreType();
        this.trustStoreType = TlsContextConfiguration.$default$trustStoreType();
        this.verifyHostname = TlsContextConfiguration.$default$verifyHostname();
    }

    @ConstructorProperties(value={"protocol", "provider", "keyStorePath", "keyStorePassword", "keyStoreType", "keyStoreProvider", "trustStorePath", "trustStorePassword", "trustStoreType", "trustStoreProvider", "trustSelfSignedCertificates", "verifyHostname", "disableSniHostCheck", "supportedProtocols", "supportedCiphers", "certAlias"})
    @Generated
    private TlsContextConfiguration(String protocol, String provider, String keyStorePath, String keyStorePassword, String keyStoreType, String keyStoreProvider, String trustStorePath, String trustStorePassword, String trustStoreType, String trustStoreProvider, boolean trustSelfSignedCertificates, boolean verifyHostname, boolean disableSniHostCheck, List<String> supportedProtocols, List<String> supportedCiphers, String certAlias) {
        this.protocol = protocol;
        this.provider = provider;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        this.keyStoreProvider = keyStoreProvider;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.trustStoreType = trustStoreType;
        this.trustStoreProvider = trustStoreProvider;
        this.trustSelfSignedCertificates = trustSelfSignedCertificates;
        this.verifyHostname = verifyHostname;
        this.disableSniHostCheck = disableSniHostCheck;
        this.supportedProtocols = supportedProtocols;
        this.supportedCiphers = supportedCiphers;
        this.certAlias = certAlias;
    }

    @Generated
    public String toString() {
        return "TlsContextConfiguration(protocol=" + this.getProtocol() + ", provider=" + this.getProvider() + ", keyStorePath=" + this.getKeyStorePath() + ", keyStoreType=" + this.getKeyStoreType() + ", keyStoreProvider=" + this.getKeyStoreProvider() + ", trustStorePath=" + this.getTrustStorePath() + ", trustStoreType=" + this.getTrustStoreType() + ", trustStoreProvider=" + this.getTrustStoreProvider() + ", trustSelfSignedCertificates=" + this.isTrustSelfSignedCertificates() + ", verifyHostname=" + this.isVerifyHostname() + ", disableSniHostCheck=" + this.isDisableSniHostCheck() + ", supportedProtocols=" + this.getSupportedProtocols() + ", supportedCiphers=" + this.getSupportedCiphers() + ", certAlias=" + this.getCertAlias() + ")";
    }

    @Generated
    public static class TlsContextConfigurationBuilder {
        @Generated
        private boolean protocol$set;
        @Generated
        private String protocol$value;
        @Generated
        private String provider;
        @Generated
        private String keyStorePath;
        @Generated
        private String keyStorePassword;
        @Generated
        private boolean keyStoreType$set;
        @Generated
        private String keyStoreType$value;
        @Generated
        private String keyStoreProvider;
        @Generated
        private String trustStorePath;
        @Generated
        private String trustStorePassword;
        @Generated
        private boolean trustStoreType$set;
        @Generated
        private String trustStoreType$value;
        @Generated
        private String trustStoreProvider;
        @Generated
        private boolean trustSelfSignedCertificates;
        @Generated
        private boolean verifyHostname$set;
        @Generated
        private boolean verifyHostname$value;
        @Generated
        private boolean disableSniHostCheck;
        @Generated
        private List<String> supportedProtocols;
        @Generated
        private List<String> supportedCiphers;
        @Generated
        private String certAlias;

        @Generated
        TlsContextConfigurationBuilder() {
        }

        @Generated
        public TlsContextConfigurationBuilder protocol(String protocol) {
            this.protocol$value = protocol;
            this.protocol$set = true;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder keyStoreType(String keyStoreType) {
            this.keyStoreType$value = keyStoreType;
            this.keyStoreType$set = true;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder keyStoreProvider(String keyStoreProvider) {
            this.keyStoreProvider = keyStoreProvider;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder trustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder trustStoreType(String trustStoreType) {
            this.trustStoreType$value = trustStoreType;
            this.trustStoreType$set = true;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder trustStoreProvider(String trustStoreProvider) {
            this.trustStoreProvider = trustStoreProvider;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder trustSelfSignedCertificates(boolean trustSelfSignedCertificates) {
            this.trustSelfSignedCertificates = trustSelfSignedCertificates;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder verifyHostname(boolean verifyHostname) {
            this.verifyHostname$value = verifyHostname;
            this.verifyHostname$set = true;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder disableSniHostCheck(boolean disableSniHostCheck) {
            this.disableSniHostCheck = disableSniHostCheck;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder supportedProtocols(List<String> supportedProtocols) {
            this.supportedProtocols = supportedProtocols;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder supportedCiphers(List<String> supportedCiphers) {
            this.supportedCiphers = supportedCiphers;
            return this;
        }

        @Generated
        public TlsContextConfigurationBuilder certAlias(String certAlias) {
            this.certAlias = certAlias;
            return this;
        }

        @Generated
        public TlsContextConfiguration build() {
            String protocol$value = this.protocol$value;
            if (!this.protocol$set) {
                protocol$value = TlsContextConfiguration.$default$protocol();
            }
            String keyStoreType$value = this.keyStoreType$value;
            if (!this.keyStoreType$set) {
                keyStoreType$value = TlsContextConfiguration.$default$keyStoreType();
            }
            String trustStoreType$value = this.trustStoreType$value;
            if (!this.trustStoreType$set) {
                trustStoreType$value = TlsContextConfiguration.$default$trustStoreType();
            }
            boolean verifyHostname$value = this.verifyHostname$value;
            if (!this.verifyHostname$set) {
                verifyHostname$value = TlsContextConfiguration.$default$verifyHostname();
            }
            return new TlsContextConfiguration(protocol$value, this.provider, this.keyStorePath, this.keyStorePassword, keyStoreType$value, this.keyStoreProvider, this.trustStorePath, this.trustStorePassword, trustStoreType$value, this.trustStoreProvider, this.trustSelfSignedCertificates, verifyHostname$value, this.disableSniHostCheck, this.supportedProtocols, this.supportedCiphers, this.certAlias);
        }

        @Generated
        public String toString() {
            return "TlsContextConfiguration.TlsContextConfigurationBuilder(protocol$value=" + this.protocol$value + ", provider=" + this.provider + ", keyStorePath=" + this.keyStorePath + ", keyStorePassword=" + this.keyStorePassword + ", keyStoreType$value=" + this.keyStoreType$value + ", keyStoreProvider=" + this.keyStoreProvider + ", trustStorePath=" + this.trustStorePath + ", trustStorePassword=" + this.trustStorePassword + ", trustStoreType$value=" + this.trustStoreType$value + ", trustStoreProvider=" + this.trustStoreProvider + ", trustSelfSignedCertificates=" + this.trustSelfSignedCertificates + ", verifyHostname$value=" + this.verifyHostname$value + ", disableSniHostCheck=" + this.disableSniHostCheck + ", supportedProtocols=" + this.supportedProtocols + ", supportedCiphers=" + this.supportedCiphers + ", certAlias=" + this.certAlias + ")";
        }
    }
}

