/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jdbc;

import com.google.common.base.Preconditions;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiPrimitives;
import org.kiwiproject.base.KiwiStrings;

public final class KiwiJdbc {
    public static void nextOrThrow(ResultSet rs) throws SQLException {
        KiwiJdbc.nextOrThrow(rs, "ResultSet.next() returned false");
    }

    public static void nextOrThrow(ResultSet rs, String message) throws SQLException {
        Preconditions.checkState((boolean)rs.next(), (Object)message);
    }

    public static void nextOrThrow(ResultSet rs, String messageTemplate, Object ... args) throws SQLException {
        if (!rs.next()) {
            throw new IllegalStateException(KiwiStrings.format(messageTemplate, args));
        }
    }

    public static long epochMillisFromTimestamp(ResultSet rs, String columnName) throws SQLException {
        return KiwiJdbc.epochMillisFromTimestamp(rs.getTimestamp(columnName));
    }

    public static long epochMillisFromTimestamp(Timestamp timestamp) {
        KiwiPreconditions.checkArgumentNotNull(timestamp, "timestamp cannot be null");
        return timestamp.toInstant().toEpochMilli();
    }

    public static java.util.Date dateFromTimestamp(ResultSet rs, String columnName) throws SQLException {
        return KiwiJdbc.dateFromTimestamp(rs.getTimestamp(columnName));
    }

    public static java.util.Date dateFromTimestamp(Timestamp timestamp) {
        return Objects.isNull(timestamp) ? null : java.util.Date.from(timestamp.toInstant());
    }

    public static Instant instantFromTimestamp(ResultSet rs, String columnName) throws SQLException {
        return KiwiJdbc.instantFromTimestamp(rs.getTimestamp(columnName));
    }

    public static Instant instantFromTimestamp(Timestamp timestamp) {
        return Objects.isNull(timestamp) ? null : timestamp.toInstant();
    }

    public static LocalDateTime localDateTimeFromTimestamp(ResultSet rs, String columnName) throws SQLException {
        return KiwiJdbc.localDateTimeFromTimestamp(rs.getTimestamp(columnName));
    }

    public static LocalDateTime localDateTimeFromTimestamp(Timestamp timestamp) {
        return Objects.isNull(timestamp) ? null : timestamp.toLocalDateTime();
    }

    public static @Nullable LocalDate localDateFromDateOrNull(ResultSet rs, String columnName) throws SQLException {
        return KiwiJdbc.localDateFromDateOrNull(rs.getDate(columnName));
    }

    public static @Nullable LocalDate localDateFromDateOrNull(@Nullable Date date) {
        return Objects.isNull(date) ? null : date.toLocalDate();
    }

    public static ZonedDateTime utcZonedDateTimeFromTimestamp(ResultSet rs, String columnName) throws SQLException {
        return KiwiJdbc.zonedDateTimeFromTimestamp(rs, columnName, ZoneOffset.UTC);
    }

    public static ZonedDateTime zonedDateTimeFromTimestamp(ResultSet rs, String columnName, ZoneId zoneId) throws SQLException {
        return KiwiJdbc.zonedDateTimeFromTimestamp(rs.getTimestamp(columnName), zoneId);
    }

    public static ZonedDateTime utcZonedDateTimeFromTimestamp(Timestamp timestamp) {
        return KiwiJdbc.zonedDateTimeFromTimestamp(timestamp, ZoneOffset.UTC);
    }

    public static ZonedDateTime utcZonedDateTimeFromEpochMilli(long epochMilli) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), ZoneOffset.UTC);
    }

    public static ZonedDateTime zonedDateTimeFromTimestamp(Timestamp timestamp, ZoneId zoneId) {
        return Objects.isNull(timestamp) ? null : ZonedDateTime.ofInstant(timestamp.toInstant(), zoneId);
    }

    public static Timestamp timestampFromInstant(Instant instant) {
        return Objects.isNull(instant) ? null : Timestamp.from(instant);
    }

    public static Timestamp timestampFromZonedDateTime(ZonedDateTime zonedDateTime) {
        return Objects.isNull(zonedDateTime) ? null : Timestamp.from(zonedDateTime.toInstant());
    }

    public static Long longValueOrNull(ResultSet rs, String columnName) throws SQLException {
        long value = rs.getLong(columnName);
        return rs.wasNull() ? null : Long.valueOf(value);
    }

    public static Integer intValueOrNull(ResultSet rs, String columnName) throws SQLException {
        int value = rs.getInt(columnName);
        return rs.wasNull() ? null : Integer.valueOf(value);
    }

    public static Double doubleValueOrNull(ResultSet rs, String columnName) throws SQLException {
        double value = rs.getDouble(columnName);
        return rs.wasNull() ? null : Double.valueOf(value);
    }

    public static <T extends Enum<T>> T enumValueOrNull(ResultSet rs, String columnName, Class<T> enumType) throws SQLException {
        return (T)((Enum)KiwiJdbc.enumValueOrEmpty(rs, columnName, enumType).orElse(null));
    }

    public static <T extends Enum<T>> Optional<T> enumValueOrEmpty(ResultSet rs, String columnName, Class<T> enumType) throws SQLException {
        String enumName = rs.getString(columnName);
        return Objects.isNull(enumName) ? Optional.empty() : Optional.of(Enum.valueOf(enumType, enumName));
    }

    public static boolean booleanFromLong(ResultSet rs, String columnName) throws SQLException {
        return KiwiJdbc.booleanFromLong(rs, columnName, KiwiPrimitives.BooleanConversionOption.ZERO_OR_ONE);
    }

    public static boolean booleanFromLong(ResultSet rs, String columnName, KiwiPrimitives.BooleanConversionOption option) throws SQLException {
        return KiwiPrimitives.booleanFromLong(rs.getLong(columnName), option);
    }

    public static boolean booleanFromInt(ResultSet rs, String columnName) throws SQLException {
        return KiwiJdbc.booleanFromInt(rs, columnName, KiwiPrimitives.BooleanConversionOption.ZERO_OR_ONE);
    }

    public static boolean booleanFromInt(ResultSet rs, String columnName, KiwiPrimitives.BooleanConversionOption option) throws SQLException {
        return KiwiPrimitives.booleanFromInt(rs.getInt(columnName), option);
    }

    public static @Nullable String stringOrNullIfBlank(ResultSet rs, String columnName) throws SQLException {
        return KiwiJdbc.stringOrNullIfBlank(rs, columnName, StringTrimOption.PRESERVE);
    }

    public static @Nullable String trimmedStringOrNullIfBlank(ResultSet rs, String columnName) throws SQLException {
        return KiwiJdbc.stringOrNullIfBlank(rs, columnName, StringTrimOption.REMOVE);
    }

    public static @Nullable String stringOrNullIfBlank(ResultSet rs, String columnName, StringTrimOption option) throws SQLException {
        String string;
        String s = rs.getString(columnName);
        if (StringUtils.isBlank((CharSequence)s)) {
            string = null;
        } else {
            switch (option) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case PRESERVE: {
                    string = s;
                    break;
                }
                case REMOVE: {
                    string = s.strip();
                }
            }
        }
        return string;
    }

    public static void nullSafeSetTimestamp(PreparedStatement ps, int parameterIndex, Timestamp value) throws SQLException {
        KiwiJdbc.nullSafeSetTimestamp(ps, parameterIndex, value, 93);
    }

    public static void nullSafeSetTimestamp(PreparedStatement ps, int parameterIndex, Timestamp value, int type) throws SQLException {
        if (Objects.isNull(value)) {
            ps.setNull(parameterIndex, type);
        } else {
            ps.setTimestamp(parameterIndex, value);
        }
    }

    public static void nullSafeSetDateAsTimestamp(PreparedStatement ps, int parameterIndex, java.util.Date value) throws SQLException {
        KiwiJdbc.nullSafeSetDateAsTimestamp(ps, parameterIndex, value, 93);
    }

    public static void nullSafeSetDateAsTimestamp(PreparedStatement ps, int parameterIndex, java.util.Date value, int type) throws SQLException {
        if (Objects.isNull(value)) {
            ps.setNull(parameterIndex, type);
        } else {
            ps.setTimestamp(parameterIndex, new Timestamp(value.getTime()));
        }
    }

    public static void nullSafeSetInt(PreparedStatement ps, int parameterIndex, Integer value) throws SQLException {
        KiwiJdbc.nullSafeSetInt(ps, parameterIndex, value, 4);
    }

    public static void nullSafeSetInt(PreparedStatement ps, int parameterIndex, Integer value, int type) throws SQLException {
        if (Objects.isNull(value)) {
            ps.setNull(parameterIndex, type);
        } else {
            ps.setInt(parameterIndex, value);
        }
    }

    public static void nullSafeSetLong(PreparedStatement ps, int parameterIndex, Long value) throws SQLException {
        KiwiJdbc.nullSafeSetLong(ps, parameterIndex, value, -5);
    }

    public static void nullSafeSetLong(PreparedStatement ps, int parameterIndex, Long value, int type) throws SQLException {
        if (Objects.isNull(value)) {
            ps.setNull(parameterIndex, type);
        } else {
            ps.setLong(parameterIndex, value);
        }
    }

    public static void nullSafeSetDouble(PreparedStatement ps, int parameterIndex, Double value) throws SQLException {
        KiwiJdbc.nullSafeSetDouble(ps, parameterIndex, value, 8);
    }

    public static void nullSafeSetDouble(PreparedStatement ps, int parameterIndex, Double value, int type) throws SQLException {
        if (Objects.isNull(value)) {
            ps.setNull(parameterIndex, type);
        } else {
            ps.setDouble(parameterIndex, value);
        }
    }

    public static void nullSafeSetString(PreparedStatement ps, int parameterIndex, String value) throws SQLException {
        KiwiJdbc.nullSafeSetString(ps, parameterIndex, value, 12);
    }

    public static void nullSafeSetString(PreparedStatement ps, int parameterIndex, String value, int type) throws SQLException {
        if (Objects.isNull(value)) {
            ps.setNull(parameterIndex, type);
        } else {
            ps.setString(parameterIndex, value);
        }
    }

    @Generated
    private KiwiJdbc() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum StringTrimOption {
        PRESERVE,
        REMOVE;

    }
}

