/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.ansible.vault;

import java.beans.ConstructorProperties;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.ansible.vault.VaultConfiguration;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.process.OsCommand;

public class VaultDecryptCommand
implements OsCommand {
    public static final String OUTPUT_FILE_STDOUT = "-";
    private final String ansibleVaultPath;
    private final String vaultPasswordFilePath;
    private final String encryptedFilePath;
    private final String outputFilePath;

    public static VaultDecryptCommand from(VaultConfiguration configuration, String encryptedFilePath) {
        return VaultDecryptCommand.from(configuration, encryptedFilePath, null);
    }

    public static VaultDecryptCommand toStdoutFrom(VaultConfiguration configuration, String encryptedFilePath) {
        return VaultDecryptCommand.from(configuration, encryptedFilePath, OUTPUT_FILE_STDOUT);
    }

    public static VaultDecryptCommand from(VaultConfiguration configuration, String encryptedFilePath, @Nullable String outputFilePath) {
        KiwiPreconditions.checkArgumentNotNull(configuration, "configuration cannot be null");
        KiwiPreconditions.checkArgumentNotBlank(encryptedFilePath, "encryptedFilePath cannot be blank");
        return VaultDecryptCommand.builder().ansibleVaultPath(configuration.getAnsibleVaultPath()).vaultPasswordFilePath(configuration.getVaultPasswordFilePath()).encryptedFilePath(encryptedFilePath).outputFilePath(outputFilePath).build();
    }

    @Override
    public List<String> parts() {
        if (Objects.nonNull(this.outputFilePath)) {
            return this.getCommandPartsWithOutputFile();
        }
        return this.getCommandPartsWithNoOutputFile();
    }

    private List<String> getCommandPartsWithOutputFile() {
        return List.of(this.ansibleVaultPath, "decrypt", "--vault-password-file", this.vaultPasswordFilePath, "--output", this.outputFilePath, Paths.get(this.encryptedFilePath, new String[0]).toString());
    }

    private List<String> getCommandPartsWithNoOutputFile() {
        return List.of(this.ansibleVaultPath, "decrypt", "--vault-password-file", this.vaultPasswordFilePath, Paths.get(this.encryptedFilePath, new String[0]).toString());
    }

    @ConstructorProperties(value={"ansibleVaultPath", "vaultPasswordFilePath", "encryptedFilePath", "outputFilePath"})
    @Generated
    VaultDecryptCommand(String ansibleVaultPath, String vaultPasswordFilePath, String encryptedFilePath, String outputFilePath) {
        this.ansibleVaultPath = ansibleVaultPath;
        this.vaultPasswordFilePath = vaultPasswordFilePath;
        this.encryptedFilePath = encryptedFilePath;
        this.outputFilePath = outputFilePath;
    }

    @Generated
    public static VaultDecryptCommandBuilder builder() {
        return new VaultDecryptCommandBuilder();
    }

    @Generated
    public static class VaultDecryptCommandBuilder {
        @Generated
        private String ansibleVaultPath;
        @Generated
        private String vaultPasswordFilePath;
        @Generated
        private String encryptedFilePath;
        @Generated
        private String outputFilePath;

        @Generated
        VaultDecryptCommandBuilder() {
        }

        @Generated
        public VaultDecryptCommandBuilder ansibleVaultPath(String ansibleVaultPath) {
            this.ansibleVaultPath = ansibleVaultPath;
            return this;
        }

        @Generated
        public VaultDecryptCommandBuilder vaultPasswordFilePath(String vaultPasswordFilePath) {
            this.vaultPasswordFilePath = vaultPasswordFilePath;
            return this;
        }

        @Generated
        public VaultDecryptCommandBuilder encryptedFilePath(String encryptedFilePath) {
            this.encryptedFilePath = encryptedFilePath;
            return this;
        }

        @Generated
        public VaultDecryptCommandBuilder outputFilePath(String outputFilePath) {
            this.outputFilePath = outputFilePath;
            return this;
        }

        @Generated
        public VaultDecryptCommand build() {
            return new VaultDecryptCommand(this.ansibleVaultPath, this.vaultPasswordFilePath, this.encryptedFilePath, this.outputFilePath);
        }

        @Generated
        public String toString() {
            return "VaultDecryptCommand.VaultDecryptCommandBuilder(ansibleVaultPath=" + this.ansibleVaultPath + ", vaultPasswordFilePath=" + this.vaultPasswordFilePath + ", encryptedFilePath=" + this.encryptedFilePath + ", outputFilePath=" + this.outputFilePath + ")";
        }
    }
}

