/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.ansible.vault;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.ansible.vault.VaultConfiguration;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.base.process.OsCommand;

public class VaultEncryptCommand
implements OsCommand {
    private final String ansibleVaultPath;
    private final String vaultIdLabel;
    private final String vaultPasswordFilePath;
    private final String plainTextFilePath;

    public static VaultEncryptCommand from(VaultConfiguration configuration, String plainTextFilePath) {
        return VaultEncryptCommand.from(configuration, null, plainTextFilePath);
    }

    public static VaultEncryptCommand from(VaultConfiguration configuration, @Nullable String vaultIdLabel, String plainTextFilePath) {
        KiwiPreconditions.checkArgumentNotNull(configuration, "configuration cannot be null");
        KiwiPreconditions.checkArgumentNotBlank(plainTextFilePath, "plainTextFilePath cannot be blank");
        return VaultEncryptCommand.builder().ansibleVaultPath(configuration.getAnsibleVaultPath()).vaultIdLabel(vaultIdLabel).vaultPasswordFilePath(configuration.getVaultPasswordFilePath()).plainTextFilePath(plainTextFilePath).build();
    }

    @Override
    public List<String> parts() {
        if (Objects.isNull(this.vaultIdLabel)) {
            return List.of(this.ansibleVaultPath, "encrypt", "--vault-password-file", this.vaultPasswordFilePath, this.plainTextFilePath);
        }
        return List.of(this.ansibleVaultPath, "encrypt", "--vault-id", this.vaultIdArgument(), this.plainTextFilePath);
    }

    private String vaultIdArgument() {
        return KiwiStrings.f("{}@{}", this.vaultIdLabel, this.vaultPasswordFilePath);
    }

    @ConstructorProperties(value={"ansibleVaultPath", "vaultIdLabel", "vaultPasswordFilePath", "plainTextFilePath"})
    @Generated
    VaultEncryptCommand(String ansibleVaultPath, String vaultIdLabel, String vaultPasswordFilePath, String plainTextFilePath) {
        this.ansibleVaultPath = ansibleVaultPath;
        this.vaultIdLabel = vaultIdLabel;
        this.vaultPasswordFilePath = vaultPasswordFilePath;
        this.plainTextFilePath = plainTextFilePath;
    }

    @Generated
    public static VaultEncryptCommandBuilder builder() {
        return new VaultEncryptCommandBuilder();
    }

    @Generated
    public static class VaultEncryptCommandBuilder {
        @Generated
        private String ansibleVaultPath;
        @Generated
        private String vaultIdLabel;
        @Generated
        private String vaultPasswordFilePath;
        @Generated
        private String plainTextFilePath;

        @Generated
        VaultEncryptCommandBuilder() {
        }

        @Generated
        public VaultEncryptCommandBuilder ansibleVaultPath(String ansibleVaultPath) {
            this.ansibleVaultPath = ansibleVaultPath;
            return this;
        }

        @Generated
        public VaultEncryptCommandBuilder vaultIdLabel(String vaultIdLabel) {
            this.vaultIdLabel = vaultIdLabel;
            return this;
        }

        @Generated
        public VaultEncryptCommandBuilder vaultPasswordFilePath(String vaultPasswordFilePath) {
            this.vaultPasswordFilePath = vaultPasswordFilePath;
            return this;
        }

        @Generated
        public VaultEncryptCommandBuilder plainTextFilePath(String plainTextFilePath) {
            this.plainTextFilePath = plainTextFilePath;
            return this;
        }

        @Generated
        public VaultEncryptCommand build() {
            return new VaultEncryptCommand(this.ansibleVaultPath, this.vaultIdLabel, this.vaultPasswordFilePath, this.plainTextFilePath);
        }

        @Generated
        public String toString() {
            return "VaultEncryptCommand.VaultEncryptCommandBuilder(ansibleVaultPath=" + this.ansibleVaultPath + ", vaultIdLabel=" + this.vaultIdLabel + ", vaultPasswordFilePath=" + this.vaultPasswordFilePath + ", plainTextFilePath=" + this.plainTextFilePath + ")";
        }
    }
}

