/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base.process;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.base.process.KillSignal;
import org.kiwiproject.base.process.KillTimeoutAction;
import org.kiwiproject.base.process.Processes;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.io.KiwiIO;

public class ProcessHelper {
    public Optional<Integer> waitForExit(Process process) {
        return Processes.waitForExit(process);
    }

    public Optional<Integer> waitForExit(Process process, long timeout, TimeUnit unit) {
        return Processes.waitForExit(process, timeout, unit);
    }

    public Process launch(List<String> command) {
        return Processes.launch(command);
    }

    public Process launch(@Nullable File workingDirectory, List<String> command) {
        return Processes.launch(workingDirectory, command);
    }

    public Process launch(String ... command) {
        return Processes.launch(command);
    }

    public List<Long> pgrep(String commandLine) {
        return Processes.pgrep(commandLine);
    }

    public List<Long> pgrep(String user, String commandLine) {
        return Processes.pgrep(user, commandLine);
    }

    public Optional<Long> pgrepWithSingleResult(String commandLine) {
        return Processes.pgrepWithSingleResult(commandLine);
    }

    public Optional<Long> pgrepWithSingleResult(String user, String commandLine) {
        return Processes.pgrepWithSingleResult(user, commandLine);
    }

    public List<String> pgrepList(String commandLine) {
        return Processes.pgrepList(commandLine);
    }

    public List<String> pgrepList(String user, String commandLine) {
        return Processes.pgrepList(user, commandLine);
    }

    public List<Pair<Long, String>> pgrepParsedList(String commandLine) {
        return Processes.pgrepParsedList(commandLine);
    }

    public List<Pair<Long, String>> pgrepParsedList(String user, String commandLine) {
        return Processes.pgrepParsedList(user, commandLine);
    }

    public int kill(long processId, KillSignal signal, KillTimeoutAction action) {
        return Processes.kill(processId, signal, action);
    }

    public int kill(long processId, KillSignal signal, long timeout, TimeUnit unit, KillTimeoutAction action) {
        return Processes.kill(processId, signal, timeout, unit, action);
    }

    public int kill(long processId, String signal, KillTimeoutAction action) {
        return Processes.kill(processId, signal, action);
    }

    public int kill(long processId, String signal, long timeout, TimeUnit unit, KillTimeoutAction action) {
        return Processes.kill(processId, signal, timeout, unit, action);
    }

    public boolean killForcibly(Process process, long timeout, TimeUnit unit) throws InterruptedException {
        return Processes.killForcibly(process, timeout, unit);
    }

    public Optional<Long> findChildProcessId(long parentProcessId) {
        return this.findChildProcessIdInternal(parentProcessId, this);
    }

    @VisibleForTesting
    Optional<Long> findChildProcessIdInternal(long parentProcessId, ProcessHelper processHelper) {
        Process process = this.launchPgrepWithParentPidFlag(parentProcessId, processHelper);
        List<String> lines = KiwiIO.readLinesFromInputStreamOf(process);
        if (lines.isEmpty()) {
            return Optional.empty();
        }
        if (lines.size() == 1) {
            return Optional.of(Processes.getPidOrThrow(KiwiLists.first(lines)));
        }
        throw new IllegalStateException("More than one child process found for process ID " + parentProcessId);
    }

    public Collection<Long> findChildProcessIds(long parentProcessId) {
        return this.findChildProcessIdsInternal(parentProcessId, this);
    }

    @VisibleForTesting
    Collection<Long> findChildProcessIdsInternal(long parentProcessId, ProcessHelper processHelper) {
        Process process = this.launchPgrepWithParentPidFlag(parentProcessId, processHelper);
        Stream<String> stream = KiwiIO.streamLinesFromInputStreamOf(process);
        return stream.map(Processes::getPidOrThrow).toList();
    }

    private Process launchPgrepWithParentPidFlag(long parentProcessId, ProcessHelper processHelper) {
        return processHelper.launch("pgrep", "-P", String.valueOf(parentProcessId));
    }

    public Optional<Path> whichAsPath(String program) {
        return Processes.whichAsPath(program);
    }

    public Optional<String> which(String program) {
        return Processes.which(program);
    }
}

