/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.collect;

import com.google.common.annotations.Beta;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.collect.MapTypeMismatchException;

public final class KiwiMaps {
    public static <K, V> boolean isNullOrEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static <K, V> boolean isNotNullOrEmpty(Map<K, V> map) {
        return !KiwiMaps.isNullOrEmpty(map);
    }

    public static <K, V> Map<K, V> newUnmodifiableHashMap(Object ... items) {
        return Collections.unmodifiableMap(KiwiMaps.newHashMap(items));
    }

    public static <K, V> Map<K, V> newHashMap(Object ... items) {
        KiwiPreconditions.checkEvenItemCount(items);
        HashMap map = new HashMap(items.length);
        KiwiMaps.populate(map, items);
        return map;
    }

    public static <K, V> Map<K, V> newUnmodifiableLinkedHashMap(Object ... items) {
        return Collections.unmodifiableMap(KiwiMaps.newLinkedHashMap(items));
    }

    public static <K, V> Map<K, V> newLinkedHashMap(Object ... items) {
        KiwiPreconditions.checkEvenItemCount(items);
        LinkedHashMap map = new LinkedHashMap(items.length);
        KiwiMaps.populate(map, items);
        return map;
    }

    public static <K extends Comparable<? super K>, V> SortedMap<K, V> newUnmodifiableTreeMap(Object ... items) {
        SortedMap<K, V> sortedMap = KiwiMaps.newTreeMap(items);
        return Collections.unmodifiableSortedMap(sortedMap);
    }

    public static <K extends Comparable<? super K>, V> SortedMap<K, V> newTreeMap(Object ... items) {
        KiwiPreconditions.checkEvenItemCount(items);
        TreeMap map = new TreeMap();
        KiwiMaps.populate(map, items);
        return map;
    }

    public static <K, V> Map<K, V> newUnmodifiableConcurrentHashMap(Object ... items) {
        return Collections.unmodifiableMap(KiwiMaps.newConcurrentHashMap(items));
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(Object ... items) {
        KiwiPreconditions.checkEvenItemCount(items);
        ConcurrentHashMap map = new ConcurrentHashMap(items.length);
        KiwiMaps.populate(map, items);
        return map;
    }

    private static <K, V> void populate(Map<K, V> map, Object ... items) {
        for (int i = 0; i < items.length; i += 2) {
            Object key = items[i];
            Object value = items[i + 1];
            map.put(key, value);
        }
    }

    public static <K, V> boolean keyExistsWithNullValue(Map<K, V> map, K key) {
        return KiwiMaps.keyExists(map, key) && Objects.isNull(map.get(key));
    }

    public static <K, V> boolean keyExistsWithNonNullValue(Map<K, V> map, K key) {
        return KiwiMaps.keyExists(map, key) && Objects.nonNull(map.get(key));
    }

    private static <K, V> boolean keyExists(Map<K, V> map, K key) {
        return KiwiMaps.isNotNullOrEmpty(map) && map.containsKey(key);
    }

    public static <K, V> V getOrThrow(Map<K, V> map, K key) {
        KiwiMaps.checkMapAndKeyArgsNotNull(map, key);
        if (map.containsKey(key)) {
            V v = map.get(key);
            if (Objects.isNull(v)) {
                throw new NoSuchElementException(KiwiStrings.f("value associated with key '{}' is null", key));
            }
            return v;
        }
        throw new NoSuchElementException(KiwiStrings.f("key '{}' does not exist in map", key));
    }

    public static <K, V, E extends RuntimeException> V getOrThrow(Map<K, V> map, K key, Supplier<E> exceptionSupplier) {
        return KiwiMaps.getOrThrowChecked(map, key, exceptionSupplier);
    }

    public static <K, V, E extends Exception> V getOrThrowChecked(Map<K, V> map, K key, Supplier<E> exceptionSupplier) throws E {
        KiwiMaps.checkMapAndKeyArgsNotNull(map, key);
        KiwiPreconditions.checkArgumentNotNull(exceptionSupplier, "exceptionSupplier must not be null");
        if (map.containsKey(key)) {
            V v = map.get(key);
            if (Objects.isNull(v)) {
                throw (Exception)exceptionSupplier.get();
            }
            return v;
        }
        throw (Exception)exceptionSupplier.get();
    }

    public static @Nullable String getAsStringOrNull(Map<?, ?> map, Object key) {
        return KiwiMaps.getAsString(map, key, null);
    }

    public static @Nullable String getAsString(Map<?, ?> map, Object key, @Nullable String defaultValue) {
        return KiwiMaps.getConvertedValue(map, key, v -> Objects.isNull(v) ? defaultValue : v.toString());
    }

    public static <T> @Nullable T getTypedValueOrNull(Map<?, ?> map, Object key, Class<T> valueType) {
        return KiwiMaps.getTypedValue(map, key, valueType, null);
    }

    public static <T> @Nullable T getTypedValue(Map<?, ?> map, Object key, Class<T> valueType, @Nullable T defaultValue) {
        KiwiMaps.checkMapAndKeyArgsNotNull(map, key);
        KiwiMaps.checkValueTypeNotNull(valueType);
        try {
            return (T)KiwiMaps.getConvertedValue(map, key, v -> Objects.isNull(v) ? defaultValue : valueType.cast(v));
        }
        catch (ClassCastException e) {
            throw MapTypeMismatchException.forTypeMismatch(key, valueType, e);
        }
    }

    public static <T> @Nullable Collection<T> getTypedCollectionOrNull(Map<?, ?> map, Object key, Class<T> valueType) {
        return KiwiMaps.getTypedCollection(map, key, valueType, null);
    }

    public static <T> Collection<T> getTypedCollectionOrEmpty(Map<?, ?> map, Object key, Class<T> valueType) {
        return KiwiMaps.getTypedCollection(map, key, valueType, List.of());
    }

    public static <T> @Nullable Collection<T> getTypedCollection(Map<?, ?> map, Object key, Class<T> valueType, @Nullable Collection<T> defaultValue) {
        KiwiMaps.checkMapAndKeyArgsNotNull(map, key);
        KiwiMaps.checkValueTypeNotNull(valueType);
        try {
            return KiwiMaps.getConvertedValue(map, key, v -> Objects.isNull(v) ? defaultValue : (Collection)KiwiMaps.uncheckedCast(v));
        }
        catch (ClassCastException e) {
            throw MapTypeMismatchException.forTypeMismatch(key, Collection.class, e);
        }
    }

    public static <T> @Nullable List<T> getTypedListOrNull(Map<?, ?> map, Object key, Class<T> valueType) {
        return KiwiMaps.getTypedList(map, key, valueType, null);
    }

    public static <T> List<T> getTypedListOrEmpty(Map<?, ?> map, Object key, Class<T> valueType) {
        return KiwiMaps.getTypedList(map, key, valueType, List.of());
    }

    public static <T> @Nullable List<T> getTypedList(Map<?, ?> map, Object key, Class<T> valueType, @Nullable List<T> defaultValue) {
        KiwiMaps.checkMapAndKeyArgsNotNull(map, key);
        KiwiMaps.checkValueTypeNotNull(valueType);
        try {
            return KiwiMaps.getConvertedValue(map, key, v -> Objects.isNull(v) ? defaultValue : (List)KiwiMaps.uncheckedCast(v));
        }
        catch (ClassCastException e) {
            throw MapTypeMismatchException.forTypeMismatch(key, List.class, e);
        }
    }

    public static <T> @Nullable Set<T> getTypedSetOrNull(Map<?, ?> map, Object key, Class<T> valueType) {
        return KiwiMaps.getTypedSet(map, key, valueType, null);
    }

    public static <T> Set<T> getTypedSetOrEmpty(Map<?, ?> map, Object key, Class<T> valueType) {
        return KiwiMaps.getTypedSet(map, key, valueType, Set.of());
    }

    public static <T> @Nullable Set<T> getTypedSet(Map<?, ?> map, Object key, Class<T> valueType, @Nullable Set<T> defaultValue) {
        KiwiMaps.checkMapAndKeyArgsNotNull(map, key);
        KiwiMaps.checkValueTypeNotNull(valueType);
        try {
            return KiwiMaps.getConvertedValue(map, key, v -> Objects.isNull(v) ? defaultValue : (Set)KiwiMaps.uncheckedCast(v));
        }
        catch (ClassCastException e) {
            throw MapTypeMismatchException.forTypeMismatch(key, Set.class, e);
        }
    }

    public static <K, V> @Nullable Map<K, V> getTypedMapOrNull(Map<?, ?> map, Object key, Class<K> keyType, Class<V> valueType) {
        return KiwiMaps.getTypedMap(map, key, keyType, valueType, null);
    }

    public static <K, V> Map<K, V> getTypedMapOrEmpty(Map<?, ?> map, Object key, Class<K> keyType, Class<V> valueType) {
        return KiwiMaps.getTypedMap(map, key, keyType, valueType, Map.of());
    }

    public static <K, V> @Nullable Map<K, V> getTypedMap(Map<?, ?> map, Object key, Class<K> keyType, Class<V> valueType, @Nullable Map<K, V> defaultValue) {
        KiwiMaps.checkMapAndKeyArgsNotNull(map, key);
        KiwiPreconditions.checkArgumentNotNull(keyType, "keyType must not be null");
        KiwiMaps.checkValueTypeNotNull(valueType);
        try {
            return KiwiMaps.getConvertedValue(map, key, v -> Objects.isNull(v) ? defaultValue : (Map)KiwiMaps.uncheckedCast(v));
        }
        catch (ClassCastException e) {
            throw MapTypeMismatchException.forTypeMismatch(key, Map.class, e);
        }
    }

    private static <V> void checkValueTypeNotNull(Class<V> valueType) {
        KiwiPreconditions.checkArgumentNotNull(valueType, "valueType must not be null");
    }

    private static <T> T uncheckedCast(Object object) {
        return (T)object;
    }

    @Beta
    public static <T> @Nullable T getConvertedValue(Map<?, ?> map, Object key, Function<Object, T> converter) {
        KiwiMaps.checkMapAndKeyArgsNotNull(map, key);
        KiwiPreconditions.checkArgumentNotNull(converter, "converter function must not be null");
        Object v = map.getOrDefault(key, null);
        return converter.apply(v);
    }

    @Beta
    public static <T> @Nullable T getConvertedValueWithFallback(Map<?, ?> map, Object key, Function<Object, T> converter, BiFunction<Object, Exception, T> fallbackConverter) {
        KiwiMaps.checkMapAndKeyArgsNotNull(map, key);
        KiwiPreconditions.checkArgumentNotNull(converter, "converter function must not be null");
        KiwiPreconditions.checkArgumentNotNull(fallbackConverter, "fallbackConverter must not be null");
        Object v = map.getOrDefault(key, null);
        try {
            return converter.apply(v);
        }
        catch (Exception e) {
            return fallbackConverter.apply(v, e);
        }
    }

    private static void checkMapAndKeyArgsNotNull(Map<?, ?> map, Object key) {
        KiwiPreconditions.checkArgumentNotNull(map, "map must not be null");
        KiwiPreconditions.checkArgumentNotNull(key, "key must not be null");
    }

    @Generated
    private KiwiMaps() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

