/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiLists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KiwiJars {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(KiwiJars.class);
    private static final String QUOTED_FILE_SEPARATOR = Pattern.quote(File.separator);

    public static List<String> getPathComponents(Class<?> classInJar) {
        KiwiPreconditions.checkArgumentNotNull(classInJar, "classInJar cannot be null");
        try {
            CodeSource codeSource = classInJar.getProtectionDomain().getCodeSource();
            Preconditions.checkNotNull((Object)codeSource, (String)"Code source for %s is null", classInJar);
            String encodedJarPath = codeSource.getLocation().getPath();
            String decodedJarPath = URLDecoder.decode(encodedJarPath, StandardCharsets.UTF_8);
            return Lists.newArrayList((Object[])decodedJarPath.trim().split(QUOTED_FILE_SEPARATOR));
        }
        catch (Exception e) {
            return KiwiJars.logExceptionAndReturnEmptyList(e, classInJar);
        }
    }

    @VisibleForTesting
    static List<String> logExceptionAndReturnEmptyList(Exception ex, Class<?> classInJar) {
        LOG.error("Error getting Jar path components for {}! (turn on DEBUG logging to see stack traces)", classInJar);
        LOG.debug("Exception related to {}:", classInJar, (Object)ex);
        return Collections.emptyList();
    }

    public static Optional<String> getPath(Class<?> classInJar) {
        List<String> pathComponents = KiwiJars.getPathComponents(classInJar);
        return KiwiJars.joined(pathComponents);
    }

    public static Optional<String> getDirectoryPath(Class<?> classInJar) {
        List<String> pathComponents = KiwiJars.getPathComponents(classInJar);
        Preconditions.checkState((boolean)KiwiLists.isNotNullOrEmpty(pathComponents), (Object)"there must be at least one path component!");
        return KiwiJars.joined(pathComponents.subList(0, pathComponents.size() - 1));
    }

    @VisibleForTesting
    static Optional<String> joined(List<String> parts) {
        if (KiwiLists.isNullOrEmpty(parts)) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)File.separator, parts));
    }

    public static Optional<String> readSingleValueFromJarManifest(String mainAttributeName) {
        return KiwiJars.readSingleValueFromJarManifest(KiwiJars.class.getClassLoader(), mainAttributeName, null);
    }

    public static Optional<String> readSingleValueFromJarManifest(ClassLoader classLoader, String mainAttributeName) {
        return KiwiJars.readSingleValueFromJarManifest(classLoader, mainAttributeName, null);
    }

    public static Optional<String> readSingleValueFromJarManifest(ClassLoader classLoader, String mainAttributeName, @Nullable Predicate<URL> manifestFilter) {
        try {
            Manifest manifest = KiwiJars.findManifestOrNull(classLoader, manifestFilter);
            if (Objects.isNull(manifest)) {
                return Optional.empty();
            }
            String value = manifest.getMainAttributes().getValue(mainAttributeName);
            return Optional.ofNullable(value);
        }
        catch (Exception e) {
            LOG.warn("Unable to get main attribute {} from JAR manifest", (Object)mainAttributeName, (Object)e);
            return Optional.empty();
        }
    }

    public static Map<String, String> readValuesFromJarManifest(String ... mainAttributeNames) {
        return KiwiJars.readValuesFromJarManifest(KiwiJars.class.getClassLoader(), null, mainAttributeNames);
    }

    public static Map<String, String> readValuesFromJarManifest(ClassLoader classLoader, String ... mainAttributeNames) {
        return KiwiJars.readValuesFromJarManifest(classLoader, null, mainAttributeNames);
    }

    public static Map<String, String> readValuesFromJarManifest(ClassLoader classLoader, @Nullable Predicate<URL> manifestFilter, String ... mainAttributeNames) {
        Set<String> uniqueNames = Set.of(mainAttributeNames);
        return KiwiJars.readMainAttributesFromJarManifest(classLoader, entry -> uniqueNames.contains(entry.getKey()), manifestFilter);
    }

    public static Map<String, String> readAllMainAttributesFromJarManifest() {
        return KiwiJars.readAllMainAttributesFromJarManifest(KiwiJars.class.getClassLoader(), null);
    }

    public static Map<String, String> readAllMainAttributesFromJarManifest(ClassLoader classLoader) {
        return KiwiJars.readAllMainAttributesFromJarManifest(classLoader, null);
    }

    public static Map<String, String> readAllMainAttributesFromJarManifest(ClassLoader classLoader, @Nullable Predicate<URL> manifestFilter) {
        return KiwiJars.readMainAttributesFromJarManifest(classLoader, entry -> true, manifestFilter);
    }

    private static Map<String, String> readMainAttributesFromJarManifest(ClassLoader classLoader, Predicate<Map.Entry<String, String>> entryPredicate, @Nullable Predicate<URL> manifestFilter) {
        try {
            Manifest manifest = KiwiJars.findManifestOrNull(classLoader, manifestFilter);
            if (Objects.isNull(manifest)) {
                return Map.of();
            }
            return manifest.getMainAttributes().entrySet().stream().map(KiwiJars::toEntryOfStringToString).filter(entryPredicate).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (Exception e) {
            LOG.warn("Unable to get main attributes from JAR manifest", (Throwable)e);
            return Map.of();
        }
    }

    private static Map.Entry<String, String> toEntryOfStringToString(Map.Entry<Object, Object> e) {
        return Map.entry(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
    }

    private static @Nullable Manifest findManifestOrNull(ClassLoader classLoader, @Nullable Predicate<URL> manifestFilter) throws IOException {
        List<URL> urls = KiwiJars.findManifestUrls(classLoader, manifestFilter);
        if (KiwiLists.isNullOrEmpty(urls)) {
            LOG.warn("There are no manifest URLs! The ClassLoader may have returned no resources or the manifestFilter did not match any URLs.");
            return null;
        }
        return KiwiJars.readFirstManifestOrNull(urls);
    }

    private static List<URL> findManifestUrls(ClassLoader classLoader, @Nullable Predicate<URL> manifestFilter) throws IOException {
        if (Objects.isNull(manifestFilter)) {
            Optional<URL> manifestUrl = Optional.ofNullable(classLoader.getResource("META-INF/MANIFEST.MF"));
            return manifestUrl.map(List::of).orElseGet(List::of);
        }
        Iterator<URL> urlIterator = classLoader.getResources("META-INF/MANIFEST.MF").asIterator();
        Iterable urlIterable = () -> urlIterator;
        return StreamSupport.stream(urlIterable.spliterator(), false).filter(manifestFilter).toList();
    }

    @VisibleForTesting
    static @Nullable Manifest readFirstManifestOrNull(List<URL> urls) {
        LOG.trace("Using manifest URL(s): {}", urls);
        Manifest manifest = urls.stream().map(KiwiJars::readManifest).flatMap(Optional::stream).findFirst().orElse(null);
        if (Objects.isNull(manifest)) {
            LOG.warn("Unable to get a manifest using URLs: {}", urls);
        }
        return manifest;
    }

    private static Optional<Manifest> readManifest(URL url) {
        Optional<Manifest> optional;
        block8: {
            InputStream in = url.openStream();
            try {
                optional = Optional.of(new Manifest(in));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn("Unable to read manifest from URL: {}", (Object)url, (Object)e);
                    return Optional.empty();
                }
            }
            in.close();
        }
        return optional;
    }

    @Generated
    private KiwiJars() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

