/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jaxrs;

import com.google.common.base.Preconditions;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.jaxrs.KiwiResources;
import org.kiwiproject.jaxrs.exception.JaxrsException;
import org.kiwiproject.jaxrs.exception.JaxrsExceptionMapper;

public final class KiwiStandardResponses {
    public static <T> Response standardGetResponse(String identifierField, Object identifier, @Nullable T entity, Class<T> entityType) {
        if (Objects.nonNull(entity)) {
            return Response.ok(entity).type("application/json").build();
        }
        String message = KiwiStrings.f("{} with {} {} not found", entityType.getSimpleName(), identifierField, identifier);
        return KiwiStandardResponses.standardNotFoundResponse(message);
    }

    public static <T> Response standardGetResponse(String identifierField, Object identifier, Optional<T> entity, Class<T> entityType) {
        return KiwiStandardResponses.standardGetResponse(identifierField, identifier, entity.orElse(null), entityType);
    }

    public static <T> Response standardGetResponse(String identifierField, Object identifier, @Nullable T entity) {
        if (Objects.nonNull(entity)) {
            return Response.ok(entity).type("application/json").build();
        }
        String message = KiwiStrings.f("Object with {} {} not found", identifierField, identifier);
        return KiwiStandardResponses.standardNotFoundResponse(message);
    }

    public static <T> Response standardGetResponse(String identifierField, Object identifier, Optional<T> entity) {
        return KiwiStandardResponses.standardGetResponse(identifierField, identifier, entity.orElse(null));
    }

    public static <T> Response standardGetResponse(@Nullable T entity, String notFoundMessage) {
        if (Objects.nonNull(entity)) {
            return Response.ok(entity).type("application/json").build();
        }
        return KiwiStandardResponses.standardNotFoundResponse(notFoundMessage);
    }

    public static <T> Response standardGetResponse(Optional<T> entity, String notFoundMessage) {
        return KiwiStandardResponses.standardGetResponse(entity.orElse(null), notFoundMessage);
    }

    public static Response standardPostResponse(URI location, Object entity) {
        return KiwiStandardResponses.standardPostResponseBuilder(location, entity).build();
    }

    public static Response.ResponseBuilder standardPostResponseBuilder(URI location, Object entity) {
        return KiwiResources.createdResponseBuilder(location, entity).type("application/json");
    }

    public static Response standardPutResponse(Object entity) {
        return KiwiStandardResponses.standardPutResponseBuilder(entity).build();
    }

    public static Response.ResponseBuilder standardPutResponseBuilder(Object entity) {
        return KiwiResources.okResponseBuilder(entity).type("application/json");
    }

    public static Response standardPatchResponse(Object entity) {
        return KiwiStandardResponses.standardPatchResponseBuilder(entity).build();
    }

    public static Response.ResponseBuilder standardPatchResponseBuilder(Object entity) {
        return KiwiStandardResponses.standardPutResponseBuilder(entity);
    }

    public static Response standardDeleteResponse() {
        return KiwiStandardResponses.standardDeleteResponseBuilder().build();
    }

    public static Response.ResponseBuilder standardDeleteResponseBuilder() {
        return Response.noContent().type("application/json");
    }

    public static Response standardDeleteResponse(Object deletedEntity) {
        return KiwiStandardResponses.standardDeleteResponseBuilder(deletedEntity).build();
    }

    public static Response.ResponseBuilder standardDeleteResponseBuilder(Object deletedEntity) {
        return Response.ok((Object)deletedEntity).type("application/json");
    }

    public static Response standardBadRequestResponse(String errorDetails) {
        return KiwiStandardResponses.standardBadRequestResponseBuilder(errorDetails).build();
    }

    public static Response.ResponseBuilder standardBadRequestResponseBuilder(String errorDetails) {
        return KiwiStandardResponses.standardErrorResponseBuilder(Response.Status.BAD_REQUEST, errorDetails);
    }

    public static Response standardUnauthorizedResponse(String errorDetails) {
        return KiwiStandardResponses.standardUnauthorizedResponseBuilder(errorDetails).build();
    }

    public static Response.ResponseBuilder standardUnauthorizedResponseBuilder(String errorDetails) {
        return KiwiStandardResponses.standardErrorResponseBuilder(Response.Status.UNAUTHORIZED, errorDetails);
    }

    public static Response standardNotFoundResponse(String errorDetails) {
        return KiwiStandardResponses.standardNotFoundResponseBuilder(errorDetails).build();
    }

    public static Response.ResponseBuilder standardNotFoundResponseBuilder(String errorDetails) {
        return KiwiStandardResponses.standardErrorResponseBuilder(Response.Status.NOT_FOUND, errorDetails);
    }

    public static Response standardInternalServerErrorResponse(String errorDetails) {
        return KiwiStandardResponses.standardInternalServerErrorResponseBuilder(errorDetails).build();
    }

    public static Response.ResponseBuilder standardInternalServerErrorResponseBuilder(String errorDetails) {
        return KiwiStandardResponses.standardErrorResponseBuilder(Response.Status.INTERNAL_SERVER_ERROR, errorDetails);
    }

    public static Response standardErrorResponse(Response.Status status, String errorDetails) {
        return KiwiStandardResponses.standardErrorResponseBuilder(status, errorDetails).build();
    }

    public static Response.ResponseBuilder standardErrorResponseBuilder(Response.Status status, String errorDetails) {
        Response.Status.Family family = status.getFamily();
        int statusCode = status.getStatusCode();
        Preconditions.checkArgument((family == Response.Status.Family.CLIENT_ERROR || family == Response.Status.Family.SERVER_ERROR ? 1 : 0) != 0, (String)"status %s is not a client error (4xx) or server error (5xx)", (int)statusCode);
        return JaxrsExceptionMapper.buildResponseBuilder(new JaxrsException(errorDetails, statusCode));
    }

    public static Response standardAcceptedResponse(Object entity) {
        return KiwiStandardResponses.standardAcceptedResponseBuilder(entity).build();
    }

    public static Response.ResponseBuilder standardAcceptedResponseBuilder(Object entity) {
        return Response.accepted((Object)entity).type("application/json");
    }

    @Generated
    private KiwiStandardResponses() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

