/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jaxrs.exception;

import com.google.common.base.Verify;
import jakarta.ws.rs.WebApplicationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.collect.KiwiMaps;
import org.kiwiproject.collect.KiwiSets;
import org.kiwiproject.jaxrs.exception.ErrorMessage;

public class JaxrsException
extends RuntimeException {
    private static final String ROLLUP_MESSAGE = "Rollup of %s exceptions.";
    private static final Set<String> CONFLICT_EXCEPTION_TYPES = Set.of("org.springframework.dao.OptimisticLockingFailureException", "org.springframework.dao.PessimisticLockingFailureException", "org.springframework.dao.DataIntegrityViolationException", "org.hibernate.dialect.lock.OptimisticEntityLockException", "org.hibernate.dialect.lock.OptimisticLockException", "org.hibernate.dialect.lock.PessimisticEntityLockException", "java.lang.IllegalMonitorStateException");
    private final Integer status;
    private final transient List<ErrorMessage> errors = new ArrayList<ErrorMessage>();
    private final transient Map<String, Object> otherData = new HashMap<String, Object>();

    public JaxrsException(Throwable cause) {
        this(cause, JaxrsException.getErrorCode(cause));
    }

    public JaxrsException(String message) {
        this(new ErrorMessage(message));
    }

    public JaxrsException(String message, int statusCode) {
        this(new ErrorMessage(statusCode, message));
    }

    public JaxrsException(String message, Throwable cause) {
        this(message, cause, JaxrsException.getErrorCode(cause));
    }

    public JaxrsException(String message, Throwable cause, int statusCode) {
        this(new ErrorMessage(statusCode, message), cause);
    }

    public JaxrsException(ErrorMessage error) {
        this(error, null);
    }

    public JaxrsException(Throwable cause, int statusCode) {
        this(new ErrorMessage(statusCode, JaxrsException.nullSafeMessage(cause)), cause);
    }

    public JaxrsException(ErrorMessage error, Throwable cause) {
        super(JaxrsException.nonNullMessage(error), cause);
        this.status = null;
        this.errors.add(JaxrsException.nonNullError(error, cause));
    }

    private static ErrorMessage nonNullError(ErrorMessage error, Throwable cause) {
        return Objects.isNull(error) ? new ErrorMessage(JaxrsException.nullSafeMessage(cause)) : error;
    }

    private static String nullSafeMessage(Throwable throwable) {
        return Objects.isNull(throwable) ? null : throwable.getMessage();
    }

    public JaxrsException(List<ErrorMessage> errors, @Nullable Integer statusCode) {
        super(JaxrsException.nonNullMessage(JaxrsException.firstErrorOrNull(errors)));
        this.status = statusCode;
        this.setErrors(errors);
    }

    private static String nonNullMessage(ErrorMessage error) {
        return Objects.isNull(error) ? "Unknown error" : error.getMessage();
    }

    private static ErrorMessage firstErrorOrNull(List<ErrorMessage> errors) {
        return KiwiLists.isNotNullOrEmpty(errors) ? KiwiLists.first(errors) : null;
    }

    public JaxrsException(List<JaxrsException> exceptions) {
        super(JaxrsException.rollupMessageOrDefault(exceptions));
        this.status = null;
        if (KiwiLists.isNotNullOrEmpty(exceptions)) {
            exceptions.forEach(jaxrsException -> {
                this.errors.addAll(jaxrsException.getErrors());
                this.addOtherData(jaxrsException.getOtherData());
            });
        }
    }

    private static String rollupMessageOrDefault(List<JaxrsException> exceptions) {
        return KiwiLists.isNullOrEmpty(exceptions) ? "Unknown error" : KiwiStrings.format(ROLLUP_MESSAGE, exceptions.size());
    }

    public static JaxrsException buildJaxrsException(Throwable throwable) {
        JaxrsException jaxrsException;
        return throwable instanceof JaxrsException ? (jaxrsException = (JaxrsException)throwable) : new JaxrsException(throwable);
    }

    public List<ErrorMessage> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    protected final void setErrors(List<ErrorMessage> errorMessages) {
        if (KiwiLists.isNotNullOrEmpty(errorMessages)) {
            this.errors.clear();
            this.errors.addAll(errorMessages);
        }
    }

    public int getStatusCode() {
        return Objects.nonNull(this.status) ? this.status.intValue() : this.getRollUpStatus();
    }

    public int getRollUpStatus() {
        if (KiwiLists.isNullOrEmpty(this.errors)) {
            return 500;
        }
        if (KiwiLists.hasOneElement(this.errors)) {
            return KiwiLists.first(this.errors).getCode();
        }
        Verify.verify((this.errors.size() > 1 ? 1 : 0) != 0, (String)"Expecting more than one error at this point", (Object[])new Object[0]);
        Set uniqueStatusCodes = this.errors.stream().map(ErrorMessage::getCode).collect(Collectors.toUnmodifiableSet());
        if (KiwiSets.hasOneElement(uniqueStatusCodes)) {
            return (Integer)uniqueStatusCodes.iterator().next();
        }
        return uniqueStatusCodes.stream().max(Integer::compareTo).map(highestCode -> highestCode / 100 * 100).orElseThrow();
    }

    public Map<String, Object> getOtherData() {
        return Collections.unmodifiableMap(this.otherData);
    }

    public void setOtherData(Map<String, Object> newDataToAppend) {
        if (KiwiMaps.isNullOrEmpty(newDataToAppend)) {
            this.otherData.clear();
        } else {
            this.otherData.putAll(newDataToAppend);
        }
    }

    private void addOtherData(Map<String, Object> data) {
        if (KiwiMaps.isNullOrEmpty(data)) {
            return;
        }
        this.otherData.putAll(data);
    }

    public static int getErrorCode(Throwable throwable) {
        if (Objects.isNull(throwable)) {
            return 500;
        }
        if (throwable instanceof JaxrsException) {
            JaxrsException jaxrsException = (JaxrsException)throwable;
            return jaxrsException.getStatusCode();
        }
        if (throwable instanceof WebApplicationException) {
            WebApplicationException webApplicationException = (WebApplicationException)throwable;
            return webApplicationException.getResponse().getStatus();
        }
        if (throwable instanceof IllegalArgumentException) {
            return 400;
        }
        if (throwable instanceof IllegalStateException) {
            return 409;
        }
        String canonicalName = throwable.getClass().getCanonicalName();
        String className = Optional.ofNullable(canonicalName).orElse("NoCanonicalClassName");
        if (CONFLICT_EXCEPTION_TYPES.contains(className)) {
            return 409;
        }
        return 500;
    }
}

