/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.jsch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.jsch.JSchSlf4jLogger;
import org.kiwiproject.jsch.KiwiJSchHelpers;
import org.kiwiproject.jsch.SftpConfig;
import org.kiwiproject.jsch.SftpTransfersException;
import org.kiwiproject.jsch.ThrowingConsumer;
import org.kiwiproject.jsch.ThrowingFunction;
import org.slf4j.LoggerFactory;

public class SftpConnector {
    @Generated
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(SftpConnector.class);
    private static final String SFTP_NOT_CONNECTED = "Sftp is not connected. Call connect first";
    private final SftpConfig config;
    private final JSch jsch;
    private Session session;
    private ChannelSftp sftpChannel;

    public SftpConnector(SftpConfig config) {
        this(new JSch(), config);
    }

    public SftpConnector(JSch jsch, SftpConfig config) {
        this.config = KiwiPreconditions.requireNotNull(config, "SftpConfig is required", new Object[0]);
        this.jsch = KiwiPreconditions.requireNotNull(jsch, "JSch is required", new Object[0]);
    }

    public static SftpConnector setupAndOpenConnection(SftpConfig config) {
        return SftpConnector.setupAndOpenConnection(new JSch(), config);
    }

    @VisibleForTesting
    static SftpConnector setupAndOpenConnection(JSch jsch, SftpConfig config) {
        SftpConnector connector = new SftpConnector(jsch, config);
        connector.connect();
        return connector;
    }

    public void connect() {
        try {
            LOG.trace("Entering connect()");
            LOG.trace("Setting known hosts to {}", (Object)this.config.getKnownHostsFile());
            this.jsch.setKnownHosts(this.config.getKnownHostsFile());
            LOG.trace("Creating JSch session; connecting to: {}@{}:{}", new Object[]{this.config.getUser(), this.config.getHost(), this.config.getPort()});
            this.session = this.jsch.getSession(this.config.getUser(), this.config.getHost(), this.config.getPort());
            LOG.trace("Setting timeout to {} milliseconds", (Object)this.config.getTimeout().toMilliseconds());
            this.session.setTimeout(Ints.checkedCast((long)this.config.getTimeout().toMilliseconds()));
            LOG.trace("Setting preferred authentications to: {}", (Object)this.config.getPreferredAuthentications());
            this.session.setConfig("PreferredAuthentications", this.config.getPreferredAuthentications());
            this.setKeyExchangeTypeIfConfiguredOrDetected();
            this.addAuthToSession();
            this.disableStrictHostKeyCheckingIfConfigured();
            LOG.debug("Attempt session connect using timeout: {} millis", (Object)this.session.getTimeout());
            this.session.connect();
            LOG.debug("Session connected: {}", (Object)this.session.isConnected());
            Channel channel = this.session.openChannel("sftp");
            LOG.debug("Attempt openChannel using timeout: {} millis", (Object)this.config.getTimeout().toMilliseconds());
            channel.connect(Ints.checkedCast((long)this.config.getTimeout().toMilliseconds()));
            LOG.debug("Channel connected: {}", (Object)channel.isConnected());
            Preconditions.checkState((boolean)(channel instanceof ChannelSftp), (String)"Expected channel to be a ChannelSftp, but was a: %s", channel.getClass());
            this.sftpChannel = (ChannelSftp)channel;
            LOG.trace("Ready sftpChannel: {}", (Object)this.sftpChannel);
        }
        catch (JSchException ex) {
            throw new SftpTransfersException("Error occurred connecting to " + this.config.getHost(), ex);
        }
    }

    private void setKeyExchangeTypeIfConfiguredOrDetected() {
        this.setKeyExchangeTypeIfConfiguredOrDetected(this.session);
    }

    @VisibleForTesting
    void setKeyExchangeTypeIfConfiguredOrDetected(Session theSession) {
        this.getOrDetectKeyExchangeType().ifPresent(keyExchangeType -> this.setSessionKeyExchangeType(theSession, (String)keyExchangeType));
    }

    @VisibleForTesting
    Optional<String> getOrDetectKeyExchangeType() {
        String configuredKeyExchangeType = this.config.getKeyExchangeType();
        if (StringUtils.isNotBlank((CharSequence)configuredKeyExchangeType)) {
            LOG.trace("Using key exchange type from configuration: {}", (Object)configuredKeyExchangeType);
            return Optional.of(configuredKeyExchangeType);
        }
        Optional<String> keyExchangeTypeOptional = KiwiJSchHelpers.detectKeyExchangeTypeForHost(this.config.getHost(), this.jsch.getHostKeyRepository());
        if (keyExchangeTypeOptional.isEmpty()) {
            LOG.trace("Did not detect key exchange type in known hosts for host: {}", (Object)this.config.getHost());
        }
        return keyExchangeTypeOptional;
    }

    private void setSessionKeyExchangeType(Session theSession, String keyExchangeType) {
        KiwiJSchHelpers.setSessionKeyExchangeType(theSession, keyExchangeType);
        LOG.debug("Set key exchange type [{}] for host {}", (Object)keyExchangeType, (Object)this.config.getHost());
    }

    private void addAuthToSession() throws JSchException {
        SftpConnector.addAuthToSession(this.config, this.jsch, this.session);
    }

    @VisibleForTesting
    static void addAuthToSession(SftpConfig config, JSch jsch, Session session) throws JSchException {
        if (StringUtils.isNotBlank((CharSequence)config.getPrivateKeyFilePath())) {
            LOG.debug("Using private key '{}' to connect", (Object)config.getPrivateKeyFilePath());
            jsch.addIdentity(config.getPrivateKeyFilePath());
        } else if (StringUtils.isNotBlank((CharSequence)config.getPassword())) {
            LOG.debug("Using password to connect");
            session.setPassword(config.getPassword());
        } else {
            throw new SftpTransfersException("Missing a private key and a password; cannot authenticate to the SFTP server");
        }
    }

    private void disableStrictHostKeyCheckingIfConfigured() {
        SftpConnector.disableStrictHostKeyCheckingIfConfigured(this.config, this.session);
    }

    @VisibleForTesting
    static void disableStrictHostKeyCheckingIfConfigured(SftpConfig config, Session session) {
        if (config.isDisableStrictHostChecking()) {
            LOG.warn("Disabling strict host checking - This should only be used for testing purposes!");
            session.setConfig("StrictHostKeyChecking", "no");
        }
    }

    public void disconnect() {
        if (Objects.nonNull(this.sftpChannel)) {
            this.sftpChannel.disconnect();
            this.sftpChannel = null;
        }
        if (Objects.nonNull(this.session)) {
            this.session.disconnect();
            this.session = null;
        }
    }

    void runCommand(ThrowingConsumer<ChannelSftp, Exception> consumer) {
        this.validateSftpIsConnected();
        try {
            consumer.accept(this.sftpChannel);
        }
        catch (Exception e) {
            throw new SftpTransfersException(e);
        }
    }

    <T> T runCommandWithResponse(ThrowingFunction<ChannelSftp, T, Exception> function) {
        this.validateSftpIsConnected();
        try {
            return function.apply(this.sftpChannel);
        }
        catch (Exception e) {
            throw new SftpTransfersException(e);
        }
    }

    private void validateSftpIsConnected() {
        Preconditions.checkState((boolean)Objects.nonNull(this.sftpChannel), (Object)SFTP_NOT_CONNECTED);
        Preconditions.checkState((boolean)this.sftpChannel.isConnected(), (Object)SFTP_NOT_CONNECTED);
    }

    static {
        JSch.setLogger((Logger)new JSchSlf4jLogger(LOG));
    }
}

