/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.retry;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.base.KiwiThrowables;
import org.kiwiproject.base.UUIDs;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.retry.Attempt;
import org.kiwiproject.retry.KiwiRetryerException;
import org.kiwiproject.retry.KiwiRetryerPredicates;
import org.kiwiproject.retry.RetryException;
import org.kiwiproject.retry.RetryListener;
import org.kiwiproject.retry.RetryLogger;
import org.kiwiproject.retry.Retryer;
import org.kiwiproject.retry.RetryerBuilder;
import org.kiwiproject.retry.StopStrategies;
import org.kiwiproject.retry.StopStrategy;
import org.kiwiproject.retry.WaitStrategies;
import org.kiwiproject.retry.WaitStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class KiwiRetryer<T> {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(KiwiRetryer.class);
    private static final long DEFAULT_INITIAL_SLEEP_TIME_MILLISECONDS = 100L;
    private static final long DEFAULT_RETRY_INCREMENT_TIME_MILLISECONDS = 200L;
    private static final int DEFAULT_MAXIMUM_ATTEMPTS = 5;
    private final String retryerId;
    private final long initialSleepTimeAmount;
    private final TimeUnit initialSleepTimeUnit;
    private final long retryIncrementTimeAmount;
    private final TimeUnit retryIncrementTimeUnit;
    private final int maxAttempts;
    private final Level processingLogLevel;
    private final Level exceptionLogLevel;
    private final boolean retryOnAllExceptions;
    private final boolean retryOnAllRuntimeExceptions;
    private final List<Predicate<Exception>> exceptionPredicates;
    private final List<Predicate<T>> resultPredicates;
    private final StopStrategy stopStrategy;
    private final WaitStrategy waitStrategy;

    public static <T> KiwiRetryer<T> newRetryerWithDefaults() {
        return KiwiRetryer.builder().build();
    }

    public static <T> KiwiRetryer<T> newRetryerWithDefaultExceptions(String retryerId) {
        return KiwiRetryer.builder().retryerId(retryerId).exceptionPredicate(KiwiRetryerPredicates.CONNECTION_ERROR).exceptionPredicate(KiwiRetryerPredicates.NO_ROUTE_TO_HOST).exceptionPredicate(KiwiRetryerPredicates.SOCKET_TIMEOUT).exceptionPredicate(KiwiRetryerPredicates.UNKNOWN_HOST).build();
    }

    public static <T> KiwiRetryer<T> newRetryerRetryingAllExceptions(String retryerId) {
        return KiwiRetryer.builder().retryerId(retryerId).retryOnAllExceptions(true).build();
    }

    public static <T> KiwiRetryer<T> newRetryerRetryingAllRuntimeExceptions(String retryerId) {
        return KiwiRetryer.builder().retryerId(retryerId).retryOnAllRuntimeExceptions(true).build();
    }

    public T call(Callable<T> callable) {
        return this.call(this.retryerId, callable);
    }

    public T call(String retryerId, Callable<T> callable) {
        try {
            Retryer retryer = this.buildRetryer(retryerId);
            LOG.debug("Calling retryer with id: {}", (Object)retryerId);
            return (T)retryer.call(callable);
        }
        catch (RetryException e) {
            String message = KiwiStrings.f("KiwiRetryer {} failed all {} attempts. Error: {}", retryerId, e.getNumberOfFailedAttempts(), e.getMessage());
            throw new KiwiRetryerException(message, (Exception)((Object)e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String message = KiwiStrings.f("KiwiRetryer {} interrupted making call. Wrapped exception: {}", retryerId, e.getCause());
            throw new KiwiRetryerException(message, e);
        }
    }

    private Retryer buildRetryer(String retryerId) {
        WaitStrategy theWaitStrategy = this.determineWaitStrategy();
        StopStrategy theStopStrategy = this.determineStopStrategy();
        LoggingRetryListener theLogListener = new LoggingRetryListener(retryerId, this.processingLogLevel, this.exceptionLogLevel);
        RetryerBuilder retryerBuilder = RetryerBuilder.newBuilder().withWaitStrategy(theWaitStrategy).withStopStrategy(theStopStrategy).withRetryListener((RetryListener)theLogListener);
        if (this.retryOnAllExceptions) {
            this.logIfRetryOnRuntimeExceptionsIsSet();
            this.logIfExceptionPredicatesIsNotEmpty();
            retryerBuilder.retryIfException();
        } else if (this.retryOnAllRuntimeExceptions) {
            this.logIfExceptionPredicatesIsNotEmpty();
            retryerBuilder.retryIfRuntimeException();
        } else {
            this.exceptionPredicates.forEach(arg_0 -> ((RetryerBuilder)retryerBuilder).retryIfException(arg_0));
        }
        this.resultPredicates.forEach(arg_0 -> ((RetryerBuilder)retryerBuilder).retryIfResult(arg_0));
        return retryerBuilder.build();
    }

    private void logIfRetryOnRuntimeExceptionsIsSet() {
        if (this.retryOnAllRuntimeExceptions) {
            LOG.warn("Both retryOnAllExceptions and retryOnAllRuntimeExceptions are set; retryOnAllExceptions takes precedence");
        }
    }

    private void logIfExceptionPredicatesIsNotEmpty() {
        if (KiwiLists.isNotNullOrEmpty(this.exceptionPredicates)) {
            String field = this.retryOnAllExceptions ? "retryOnAllExceptions" : "retryOnAllRuntimeExceptions";
            LOG.warn("{} is set while exceptionPredicates is populated: {} takes precedence", (Object)field, (Object)field);
        }
    }

    private WaitStrategy determineWaitStrategy() {
        return Optional.ofNullable(this.waitStrategy).orElseGet(this::newIncrementingWaitStrategy);
    }

    private WaitStrategy newIncrementingWaitStrategy() {
        return WaitStrategies.incrementingWait((long)this.initialSleepTimeAmount, (TimeUnit)this.initialSleepTimeUnit, (long)this.retryIncrementTimeAmount, (TimeUnit)this.retryIncrementTimeUnit);
    }

    private StopStrategy determineStopStrategy() {
        return Optional.ofNullable(this.stopStrategy).orElseGet(() -> StopStrategies.stopAfterAttempt((int)this.maxAttempts));
    }

    @Generated
    private static <T> String $default$retryerId() {
        return UUIDs.randomUUIDString();
    }

    @Generated
    private static <T> long $default$initialSleepTimeAmount() {
        return 100L;
    }

    @Generated
    private static <T> TimeUnit $default$initialSleepTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    @Generated
    private static <T> long $default$retryIncrementTimeAmount() {
        return 200L;
    }

    @Generated
    private static <T> TimeUnit $default$retryIncrementTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    @Generated
    private static <T> int $default$maxAttempts() {
        return 5;
    }

    @Generated
    private static <T> Level $default$processingLogLevel() {
        return Level.DEBUG;
    }

    @Generated
    private static <T> Level $default$exceptionLogLevel() {
        return Level.WARN;
    }

    @ConstructorProperties(value={"retryerId", "initialSleepTimeAmount", "initialSleepTimeUnit", "retryIncrementTimeAmount", "retryIncrementTimeUnit", "maxAttempts", "processingLogLevel", "exceptionLogLevel", "retryOnAllExceptions", "retryOnAllRuntimeExceptions", "exceptionPredicates", "resultPredicates", "stopStrategy", "waitStrategy"})
    @Generated
    KiwiRetryer(String retryerId, long initialSleepTimeAmount, TimeUnit initialSleepTimeUnit, long retryIncrementTimeAmount, TimeUnit retryIncrementTimeUnit, int maxAttempts, Level processingLogLevel, Level exceptionLogLevel, boolean retryOnAllExceptions, boolean retryOnAllRuntimeExceptions, List<Predicate<Exception>> exceptionPredicates, List<Predicate<T>> resultPredicates, StopStrategy stopStrategy, WaitStrategy waitStrategy) {
        this.retryerId = retryerId;
        this.initialSleepTimeAmount = initialSleepTimeAmount;
        this.initialSleepTimeUnit = initialSleepTimeUnit;
        this.retryIncrementTimeAmount = retryIncrementTimeAmount;
        this.retryIncrementTimeUnit = retryIncrementTimeUnit;
        this.maxAttempts = maxAttempts;
        this.processingLogLevel = processingLogLevel;
        this.exceptionLogLevel = exceptionLogLevel;
        this.retryOnAllExceptions = retryOnAllExceptions;
        this.retryOnAllRuntimeExceptions = retryOnAllRuntimeExceptions;
        this.exceptionPredicates = exceptionPredicates;
        this.resultPredicates = resultPredicates;
        this.stopStrategy = stopStrategy;
        this.waitStrategy = waitStrategy;
    }

    @Generated
    public static <T> KiwiRetryerBuilder<T> builder() {
        return new KiwiRetryerBuilder();
    }

    @Generated
    public static class KiwiRetryerBuilder<T> {
        @Generated
        private boolean retryerId$set;
        @Generated
        private String retryerId$value;
        @Generated
        private boolean initialSleepTimeAmount$set;
        @Generated
        private long initialSleepTimeAmount$value;
        @Generated
        private boolean initialSleepTimeUnit$set;
        @Generated
        private TimeUnit initialSleepTimeUnit$value;
        @Generated
        private boolean retryIncrementTimeAmount$set;
        @Generated
        private long retryIncrementTimeAmount$value;
        @Generated
        private boolean retryIncrementTimeUnit$set;
        @Generated
        private TimeUnit retryIncrementTimeUnit$value;
        @Generated
        private boolean maxAttempts$set;
        @Generated
        private int maxAttempts$value;
        @Generated
        private boolean processingLogLevel$set;
        @Generated
        private Level processingLogLevel$value;
        @Generated
        private boolean exceptionLogLevel$set;
        @Generated
        private Level exceptionLogLevel$value;
        @Generated
        private boolean retryOnAllExceptions;
        @Generated
        private boolean retryOnAllRuntimeExceptions;
        @Generated
        private ArrayList<Predicate<Exception>> exceptionPredicates;
        @Generated
        private ArrayList<Predicate<T>> resultPredicates;
        @Generated
        private StopStrategy stopStrategy;
        @Generated
        private WaitStrategy waitStrategy;

        @Generated
        KiwiRetryerBuilder() {
        }

        @Generated
        public KiwiRetryerBuilder<T> retryerId(String retryerId) {
            this.retryerId$value = retryerId;
            this.retryerId$set = true;
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> initialSleepTimeAmount(long initialSleepTimeAmount) {
            this.initialSleepTimeAmount$value = initialSleepTimeAmount;
            this.initialSleepTimeAmount$set = true;
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> initialSleepTimeUnit(TimeUnit initialSleepTimeUnit) {
            this.initialSleepTimeUnit$value = initialSleepTimeUnit;
            this.initialSleepTimeUnit$set = true;
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> retryIncrementTimeAmount(long retryIncrementTimeAmount) {
            this.retryIncrementTimeAmount$value = retryIncrementTimeAmount;
            this.retryIncrementTimeAmount$set = true;
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> retryIncrementTimeUnit(TimeUnit retryIncrementTimeUnit) {
            this.retryIncrementTimeUnit$value = retryIncrementTimeUnit;
            this.retryIncrementTimeUnit$set = true;
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> maxAttempts(int maxAttempts) {
            this.maxAttempts$value = maxAttempts;
            this.maxAttempts$set = true;
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> processingLogLevel(Level processingLogLevel) {
            this.processingLogLevel$value = processingLogLevel;
            this.processingLogLevel$set = true;
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> exceptionLogLevel(Level exceptionLogLevel) {
            this.exceptionLogLevel$value = exceptionLogLevel;
            this.exceptionLogLevel$set = true;
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> retryOnAllExceptions(boolean retryOnAllExceptions) {
            this.retryOnAllExceptions = retryOnAllExceptions;
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> retryOnAllRuntimeExceptions(boolean retryOnAllRuntimeExceptions) {
            this.retryOnAllRuntimeExceptions = retryOnAllRuntimeExceptions;
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> exceptionPredicate(Predicate<Exception> exceptionPredicate) {
            if (this.exceptionPredicates == null) {
                this.exceptionPredicates = new ArrayList();
            }
            this.exceptionPredicates.add(exceptionPredicate);
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> exceptionPredicates(Collection<? extends Predicate<Exception>> exceptionPredicates) {
            if (exceptionPredicates == null) {
                throw new NullPointerException("exceptionPredicates cannot be null");
            }
            if (this.exceptionPredicates == null) {
                this.exceptionPredicates = new ArrayList();
            }
            this.exceptionPredicates.addAll(exceptionPredicates);
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> clearExceptionPredicates() {
            if (this.exceptionPredicates != null) {
                this.exceptionPredicates.clear();
            }
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> resultPredicate(Predicate<T> resultPredicate) {
            if (this.resultPredicates == null) {
                this.resultPredicates = new ArrayList();
            }
            this.resultPredicates.add(resultPredicate);
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> resultPredicates(Collection<? extends Predicate<T>> resultPredicates) {
            if (resultPredicates == null) {
                throw new NullPointerException("resultPredicates cannot be null");
            }
            if (this.resultPredicates == null) {
                this.resultPredicates = new ArrayList();
            }
            this.resultPredicates.addAll(resultPredicates);
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> clearResultPredicates() {
            if (this.resultPredicates != null) {
                this.resultPredicates.clear();
            }
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> stopStrategy(StopStrategy stopStrategy) {
            this.stopStrategy = stopStrategy;
            return this;
        }

        @Generated
        public KiwiRetryerBuilder<T> waitStrategy(WaitStrategy waitStrategy) {
            this.waitStrategy = waitStrategy;
            return this;
        }

        @Generated
        public KiwiRetryer<T> build() {
            List<Predicate<Exception>> exceptionPredicates = switch (this.exceptionPredicates == null ? 0 : this.exceptionPredicates.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.exceptionPredicates.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Predicate<Exception>>(this.exceptionPredicates));
            };
            List resultPredicates = switch (this.resultPredicates == null ? 0 : this.resultPredicates.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.resultPredicates.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Predicate<T>>(this.resultPredicates));
            };
            String retryerId$value = this.retryerId$value;
            if (!this.retryerId$set) {
                retryerId$value = KiwiRetryer.$default$retryerId();
            }
            long initialSleepTimeAmount$value = this.initialSleepTimeAmount$value;
            if (!this.initialSleepTimeAmount$set) {
                initialSleepTimeAmount$value = KiwiRetryer.$default$initialSleepTimeAmount();
            }
            TimeUnit initialSleepTimeUnit$value = this.initialSleepTimeUnit$value;
            if (!this.initialSleepTimeUnit$set) {
                initialSleepTimeUnit$value = KiwiRetryer.$default$initialSleepTimeUnit();
            }
            long retryIncrementTimeAmount$value = this.retryIncrementTimeAmount$value;
            if (!this.retryIncrementTimeAmount$set) {
                retryIncrementTimeAmount$value = KiwiRetryer.$default$retryIncrementTimeAmount();
            }
            TimeUnit retryIncrementTimeUnit$value = this.retryIncrementTimeUnit$value;
            if (!this.retryIncrementTimeUnit$set) {
                retryIncrementTimeUnit$value = KiwiRetryer.$default$retryIncrementTimeUnit();
            }
            int maxAttempts$value = this.maxAttempts$value;
            if (!this.maxAttempts$set) {
                maxAttempts$value = KiwiRetryer.$default$maxAttempts();
            }
            Level processingLogLevel$value = this.processingLogLevel$value;
            if (!this.processingLogLevel$set) {
                processingLogLevel$value = KiwiRetryer.$default$processingLogLevel();
            }
            Level exceptionLogLevel$value = this.exceptionLogLevel$value;
            if (!this.exceptionLogLevel$set) {
                exceptionLogLevel$value = KiwiRetryer.$default$exceptionLogLevel();
            }
            return new KiwiRetryer(retryerId$value, initialSleepTimeAmount$value, initialSleepTimeUnit$value, retryIncrementTimeAmount$value, retryIncrementTimeUnit$value, maxAttempts$value, processingLogLevel$value, exceptionLogLevel$value, this.retryOnAllExceptions, this.retryOnAllRuntimeExceptions, exceptionPredicates, resultPredicates, this.stopStrategy, this.waitStrategy);
        }

        @Generated
        public String toString() {
            return "KiwiRetryer.KiwiRetryerBuilder(retryerId$value=" + this.retryerId$value + ", initialSleepTimeAmount$value=" + this.initialSleepTimeAmount$value + ", initialSleepTimeUnit$value=" + String.valueOf((Object)this.initialSleepTimeUnit$value) + ", retryIncrementTimeAmount$value=" + this.retryIncrementTimeAmount$value + ", retryIncrementTimeUnit$value=" + String.valueOf((Object)this.retryIncrementTimeUnit$value) + ", maxAttempts$value=" + this.maxAttempts$value + ", processingLogLevel$value=" + String.valueOf(this.processingLogLevel$value) + ", exceptionLogLevel$value=" + String.valueOf(this.exceptionLogLevel$value) + ", retryOnAllExceptions=" + this.retryOnAllExceptions + ", retryOnAllRuntimeExceptions=" + this.retryOnAllRuntimeExceptions + ", exceptionPredicates=" + String.valueOf(this.exceptionPredicates) + ", resultPredicates=" + String.valueOf(this.resultPredicates) + ", stopStrategy=" + String.valueOf(this.stopStrategy) + ", waitStrategy=" + String.valueOf(this.waitStrategy) + ")";
        }
    }

    static class LoggingRetryListener
    implements RetryListener {
        private static final String RETRY_ATTEMPT_MSG = "Retryer [{}], attempt #{} [delay since first attempt: {} ms]";
        private static final String RESULT_MSG = "Result for retryer [{}]: {}";
        private static final String EXCEPTION_MESSAGE = "Exception occurred for retryer [{}]: {}: {}";
        private final String retryId;
        private final Level processingLogLevel;
        private final Level exceptionLogLevel;

        LoggingRetryListener(String id, Level processingLogLevel, Level exceptionLogLevel) {
            this.retryId = StringUtils.isBlank((CharSequence)id) ? UUIDs.randomUUIDString() : id;
            this.processingLogLevel = processingLogLevel;
            this.exceptionLogLevel = exceptionLogLevel;
        }

        public void onRetry(Attempt<?> attempt) {
            int attemptNumber = attempt.getAttemptNumber();
            RetryLogger.logAttempt(LOG, this.processingLogLevel, attemptNumber, RETRY_ATTEMPT_MSG, this.retryId, attemptNumber, attempt.getDelaySinceFirstAttempt());
            if (attempt.hasResult()) {
                this.logResultAttempt(attempt, attemptNumber);
            } else if (attempt.hasException()) {
                this.logExceptionAttempt(attempt);
            }
        }

        <V> void logResultAttempt(Attempt<V> attempt, long attemptNumber) {
            RetryLogger.logAttempt(LOG, this.processingLogLevel, attemptNumber, RESULT_MSG, this.retryId, attempt.getResult());
        }

        void logExceptionAttempt(Attempt<?> attempt) {
            Exception throwable = attempt.getException();
            String type = KiwiThrowables.typeOfNullable(throwable).orElse(null);
            String message = KiwiThrowables.messageOfNullable(throwable).orElse(null);
            RetryLogger.logAttempt(LOG, this.exceptionLogLevel, EXCEPTION_MESSAGE, this.retryId, type, message);
        }
    }
}

