/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.spring.data;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.spring.data.KiwiPaging;
import org.kiwiproject.spring.data.PagingParams;
import org.kiwiproject.spring.data.PagingQuery;
import org.kiwiproject.util.function.KiwiBiConsumers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public final class KiwiSpringMongoQueries {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(KiwiSpringMongoQueries.class);
    private static final String ANY_STRING = ".*";
    private static final String CASE_INSENSITIVE_OPTION = "i";

    public static <T, P extends PagingParams> Page<T> paginate(MongoTemplate mongoTemplate, P pagingParams, Class<T> clazz) {
        return KiwiSpringMongoQueries.paginate(mongoTemplate, pagingParams, clazz, KiwiBiConsumers.noOp());
    }

    public static <T, P extends PagingParams> Page<T> paginate(MongoTemplate mongoTemplate, P pagingParams, Class<T> clazz, BiConsumer<PagingQuery, P> criteriaBuilder) {
        KiwiPreconditions.checkArgumentNotNull(mongoTemplate);
        KiwiPreconditions.checkArgumentNotNull(pagingParams);
        KiwiPreconditions.checkArgumentNotNull(clazz);
        KiwiPreconditions.checkArgumentNotNull(criteriaBuilder);
        if (Objects.isNull(pagingParams.getLimit()) || pagingParams.getLimit() < 1) {
            LOG.warn("No limit was supplied; setting it to 1. Supply a limit to avoid this warning");
            pagingParams.setLimit(1);
        }
        if (Objects.isNull(pagingParams.getPage()) || pagingParams.getPage() < 0) {
            LOG.warn("No page number was supplied; setting it to 0. Supply a page number to avoid this warning");
            pagingParams.setPage(0);
        }
        LOG.debug("Performing search using params: {}", pagingParams);
        Pageable pageable = KiwiPaging.createPageable(pagingParams);
        PagingQuery query = new PagingQuery(mongoTemplate).with(pageable);
        criteriaBuilder.accept(query, pagingParams);
        LOG.debug("Executing query: {}", (Object)query);
        return query.findPage(clazz);
    }

    public static void addDateBounds(Query query, String propertyName, @Nullable Long startDateInclusiveMillis, @Nullable Long endDateInclusiveMillis) {
        KiwiPreconditions.checkArgumentNotNull(query);
        KiwiPreconditions.checkArgumentNotNull(propertyName);
        if (Objects.isNull(startDateInclusiveMillis) && Objects.isNull(endDateInclusiveMillis)) {
            LOG.debug("start and end are both null; ignoring");
            return;
        }
        KiwiPreconditions.checkArgumentNotNull(propertyName, "property must not be null");
        Criteria datePropertyCriteria = Criteria.where((String)propertyName);
        if (Objects.nonNull(startDateInclusiveMillis)) {
            datePropertyCriteria.gte((Object)new Date(startDateInclusiveMillis));
        }
        if (Objects.nonNull(endDateInclusiveMillis)) {
            datePropertyCriteria.lte((Object)new Date(endDateInclusiveMillis));
        }
        query.addCriteria((CriteriaDefinition)datePropertyCriteria);
    }

    public static void addPartialOrEqualMatchCriteria(Query query, String matchString, String propertyName, PartialMatchType matchType) {
        KiwiPreconditions.checkArgumentNotNull(query);
        KiwiPreconditions.checkArgumentNotNull(propertyName);
        KiwiPreconditions.checkArgumentNotNull(matchType);
        if (StringUtils.isBlank((CharSequence)matchString)) {
            LOG.debug("matchString is blank; ignoring");
            return;
        }
        Criteria matchCriteria = matchType == PartialMatchType.PARTIAL_MATCH ? Criteria.where((String)propertyName).regex(ANY_STRING + matchString + ANY_STRING, CASE_INSENSITIVE_OPTION) : Criteria.where((String)propertyName).is((Object)matchString);
        query.addCriteria((CriteriaDefinition)matchCriteria);
    }

    public static void addMultiplePartialOrEqualMatchCriteria(Query query, Collection<String> matchStrings, String propertyName, PartialMatchType matchType) {
        Criteria matchCriteria;
        KiwiPreconditions.checkArgumentNotNull(query);
        KiwiPreconditions.checkArgumentNotNull(propertyName);
        KiwiPreconditions.checkArgumentNotNull(matchType);
        if (Objects.isNull(matchStrings) || matchStrings.isEmpty()) {
            LOG.debug("matchStrings is null or empty; ignoring");
            return;
        }
        if (matchType == PartialMatchType.PARTIAL_MATCH) {
            Criteria[] termCriteria = (Criteria[])matchStrings.stream().map(term -> Criteria.where((String)propertyName).regex(ANY_STRING + term + ANY_STRING, CASE_INSENSITIVE_OPTION)).toArray(Criteria[]::new);
            matchCriteria = new Criteria().orOperator(termCriteria);
        } else {
            matchCriteria = Criteria.where((String)propertyName).in(matchStrings);
        }
        query.addCriteria((CriteriaDefinition)matchCriteria);
    }

    public static void addInCriteriaFromCsv(Query query, String csv, String propertyName) {
        KiwiSpringMongoQueries.addInCriteriaFromCsv(query, csv, propertyName, Function.identity());
    }

    public static <T> void addInCriteriaFromCsv(Query query, String csv, String propertyName, Function<String, T> converter) {
        KiwiPreconditions.checkArgumentNotNull(query);
        KiwiPreconditions.checkArgumentNotNull(propertyName);
        KiwiPreconditions.checkArgumentNotNull(converter);
        if (StringUtils.isBlank((CharSequence)csv)) {
            LOG.debug("csv is blank; ignoring");
            return;
        }
        List<String> values = KiwiStrings.nullSafeSplitOnCommas(csv);
        List<T> convertedValues = values.stream().map(converter).toList();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)propertyName).in(convertedValues));
    }

    @Generated
    private KiwiSpringMongoQueries() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum PartialMatchType {
        PARTIAL_MATCH,
        EQUAL_MATCH;


        public static PartialMatchType fromBooleanString(String value) {
            boolean allowPartialMatch = BooleanUtils.toBoolean((String)value);
            return PartialMatchType.from(allowPartialMatch);
        }

        public static PartialMatchType from(boolean value) {
            if (value) {
                return PARTIAL_MATCH;
            }
            return EQUAL_MATCH;
        }
    }
}

