/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.time;

import java.time.Duration;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.kiwiproject.base.KiwiDeprecated;

public final class KiwiDurationFormatters {
    private static final boolean SUPPRESS_LEADING_ZERO_ELEMENTS = true;
    private static final boolean SUPPRESS_TRAILING_ZERO_ELEMENTS = true;
    private static final String LITERAL_NULL = "null";

    @Deprecated(since="4.6.0", forRemoval=true)
    @KiwiDeprecated(replacedBy={"formatJavaDurationWords(java.time.Duration duration)"}, usageSeverity=KiwiDeprecated.Severity.SEVERE, removeAt="5.0.0")
    public static String formatDurationWords(Duration duration) {
        if (Objects.isNull(duration)) {
            return LITERAL_NULL;
        }
        return KiwiDurationFormatters.formatDurationWords(duration.toMillis());
    }

    public static String formatJavaDurationWords(Duration duration) {
        if (Objects.isNull(duration)) {
            return LITERAL_NULL;
        }
        return KiwiDurationFormatters.formatMillisecondDurationWords(duration.toMillis());
    }

    @Deprecated(since="4.6.0", forRemoval=true)
    @KiwiDeprecated(replacedBy={"formatDropwizardDurationWords(io.dropwizard.util.Duration duration)"}, usageSeverity=KiwiDeprecated.Severity.SEVERE, removeAt="5.0.0")
    public static String formatDurationWords(io.dropwizard.util.Duration duration) {
        if (Objects.isNull(duration)) {
            return LITERAL_NULL;
        }
        return KiwiDurationFormatters.formatDurationWords(duration.toMilliseconds());
    }

    public static String formatDropwizardDurationWords(io.dropwizard.util.Duration duration) {
        if (Objects.isNull(duration)) {
            return LITERAL_NULL;
        }
        return KiwiDurationFormatters.formatMillisecondDurationWords(duration.toMilliseconds());
    }

    @Deprecated(since="4.6.0", forRemoval=true)
    @KiwiDeprecated(replacedBy={"formatMillisecondDurationWords(long durationMillis)"}, usageSeverity=KiwiDeprecated.Severity.SEVERE, removeAt="5.0.0")
    public static String formatDurationWords(long durationMillis) {
        return DurationFormatUtils.formatDurationWords((long)durationMillis, (boolean)true, (boolean)true);
    }

    public static String formatMillisecondDurationWords(long durationMillis) {
        return DurationFormatUtils.formatDurationWords((long)durationMillis, (boolean)true, (boolean)true);
    }

    @Generated
    private KiwiDurationFormatters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

