/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.base;

import java.util.UUID;
import java.util.regex.Pattern;
import lombok.Generated;

public final class UUIDs {
    private static final String NIL_UUID = "00000000-0000-0000-0000-000000000000";
    private static final Pattern RFC4122_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}");

    public static String randomUUIDString() {
        return UUID.randomUUID().toString();
    }

    public static boolean isValidUUID(String value) {
        return RFC4122_PATTERN.matcher(value).matches();
    }

    public static boolean isValidUUIDAllowingNil(String value) {
        return NIL_UUID.equals(value) || UUIDs.isValidUUID(value);
    }

    @Generated
    private UUIDs() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

